/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.mock;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.NetAddressNameService;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.api.NetLayerStatus;
import org.silvertunnel_ng.netlib.api.NetServerSocket;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.layer.mock.MockNetSession;
import org.silvertunnel_ng.netlib.layer.mock.MockNetSocket;
import org.silvertunnel_ng.netlib.nameservice.mock.NopNetAddressNameService;

public class MockNetLayer
implements NetLayer {
    private final List<MockNetSession> sessionHistory = new ArrayList<MockNetSession>();
    private byte[] response;
    private boolean allowMultipleSessions;
    private List<byte[]> responses;
    private Map<NetAddress, byte[]> responsePerDestinationAddress;
    private boolean allowMultipleSessionsForOneAddress;
    private final long waitAtEndOfResponseBeforeClosingMs;

    public MockNetLayer(byte[] response, boolean allowMultipleSessions, long waitAtEndOfResponseBeforeClosingMs) {
        this.response = response;
        this.allowMultipleSessions = allowMultipleSessions;
        this.waitAtEndOfResponseBeforeClosingMs = waitAtEndOfResponseBeforeClosingMs;
    }

    public MockNetLayer(List<byte[]> responses, long waitAtEndOfResponseBeforeClosingMs) {
        this.responses = responses;
        this.waitAtEndOfResponseBeforeClosingMs = waitAtEndOfResponseBeforeClosingMs;
    }

    public MockNetLayer(Map<NetAddress, byte[]> responsePerDestinationAddress, boolean allowMultipleSessionsForOneAddress, long waitAtEndOfResponseBeforeClosingMs) {
        this.responsePerDestinationAddress = responsePerDestinationAddress;
        this.allowMultipleSessionsForOneAddress = allowMultipleSessionsForOneAddress;
        this.waitAtEndOfResponseBeforeClosingMs = waitAtEndOfResponseBeforeClosingMs;
    }

    public List<MockNetSession> getSessionHistory() {
        return this.sessionHistory;
    }

    public MockNetSession getFirstSessionHistory() {
        if (this.sessionHistory.size() == 0) {
            return null;
        }
        return this.sessionHistory.get(0);
    }

    @Override
    public synchronized NetSocket createNetSocket(Map<String, Object> localProperties, NetAddress localAddress, NetAddress remoteAddress) throws IOException {
        MockNetSocket preparedHigherLayerSocket;
        if (this.response != null) {
            preparedHigherLayerSocket = new MockNetSocket(this.response, this.waitAtEndOfResponseBeforeClosingMs);
            if (!this.allowMultipleSessions) {
                this.response = null;
            }
        } else if (this.responses != null && this.responses.size() >= 1) {
            preparedHigherLayerSocket = new MockNetSocket(this.responses.get(0), this.waitAtEndOfResponseBeforeClosingMs);
            this.responses.remove(0);
        } else if (this.responsePerDestinationAddress != null && this.responsePerDestinationAddress.size() >= 1) {
            byte[] response = this.responsePerDestinationAddress.get(remoteAddress);
            if (response == null) {
                throw new IOException("connection could not be established to remoteAddress=" + remoteAddress);
            }
            if (!this.allowMultipleSessionsForOneAddress) {
                this.responsePerDestinationAddress.remove(remoteAddress);
            }
            preparedHigherLayerSocket = new MockNetSocket(response, this.waitAtEndOfResponseBeforeClosingMs);
        } else {
            throw new IOException("no more Sockets allowed");
        }
        MockNetSession session = new MockNetSession(localProperties, localAddress, remoteAddress, preparedHigherLayerSocket);
        this.sessionHistory.add(session);
        return session.createHigherLayerNetSocket();
    }

    @Override
    public NetServerSocket createNetServerSocket(Map<String, Object> properties, NetAddress localListenAddress) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NetLayerStatus getStatus() {
        return NetLayerStatus.READY;
    }

    @Override
    public void waitUntilReady() {
    }

    @Override
    public void clear() throws IOException {
    }

    @Override
    public NetAddressNameService getNetAddressNameService() {
        return NopNetAddressNameService.getInstance();
    }
}

