/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.mock;

import java.io.ByteArrayInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockByteArrayInputStream
extends ByteArrayInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(MockByteArrayInputStream.class);
    private static final long ENDLESS_MS = Long.MAX_VALUE;
    private long waitAtTheEndMs;
    private Thread sleepingThread;

    public MockByteArrayInputStream(byte[] response, long waitAtTheEndMs) {
        super(response);
        this.waitAtTheEndMs = waitAtTheEndMs;
    }

    private void waitAtTheEnd() {
        if (this.waitAtTheEndMs == 0L) {
            return;
        }
        try {
            this.sleepingThread = Thread.currentThread();
            Thread.sleep(this.waitAtTheEndMs < 0L ? Long.MAX_VALUE : this.waitAtTheEndMs);
        }
        catch (InterruptedException e) {
            LOG.debug("got IterruptedException : {}", (Object)e.getMessage(), (Object)e);
        }
        this.sleepingThread = null;
        this.waitAtTheEndMs = 0L;
    }

    @Override
    public int read() {
        int result = super.read();
        if (result < 0) {
            this.waitAtTheEnd();
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int result = super.read(b, off, len);
        if (result < 0) {
            this.waitAtTheEnd();
        }
        return result;
    }

    @Override
    public void close() {
        this.waitAtTheEndMs = 0L;
        super.skip(super.available());
        Thread sThread = this.sleepingThread;
        if (sThread != null) {
            sThread.interrupt();
        }
    }
}

