/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.logger;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.silvertunnel_ng.netlib.layer.logger.BufferedLogger;

public class LoggingOutputStream
extends FilterOutputStream {
    private final BufferedLogger blog;

    protected LoggingOutputStream(OutputStream os, BufferedLogger bufferedLogger) {
        super(os);
        this.blog = bufferedLogger;
    }

    @Override
    public void write(int b) throws IOException {
        boolean unknownThrowableIsOnTheWay = true;
        try {
            this.blog.log((byte)b);
            this.out.write(b);
            unknownThrowableIsOnTheWay = false;
        }
        catch (IOException e) {
            unknownThrowableIsOnTheWay = false;
            this.blog.flush();
            this.blog.logSummaryLine("throwable detected: " + e);
            throw e;
        }
        catch (RuntimeException e) {
            unknownThrowableIsOnTheWay = false;
            this.blog.flush();
            this.blog.logSummaryLine("throwable detected: " + e);
            throw e;
        }
        finally {
            if (unknownThrowableIsOnTheWay) {
                this.blog.flush();
                this.blog.logSummaryLine("throwable detected");
            }
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        boolean unknownThrowableIsOnTheWay = true;
        if ((off | len | b.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        try {
            for (int i = 0; i < len; ++i) {
                this.blog.log(b[off + i]);
            }
            this.blog.flush();
            this.out.write(b, off, len);
            unknownThrowableIsOnTheWay = false;
        }
        catch (IOException e) {
            unknownThrowableIsOnTheWay = false;
            this.blog.flush();
            this.blog.logSummaryLine("throwable detected: " + e);
            throw e;
        }
        catch (RuntimeException e) {
            unknownThrowableIsOnTheWay = false;
            this.blog.flush();
            this.blog.logSummaryLine("throwable detected: " + e);
            throw e;
        }
        finally {
            if (unknownThrowableIsOnTheWay) {
                this.blog.flush();
                this.blog.logSummaryLine("throwable detected");
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.blog.flush();
        super.flush();
    }

    @Override
    public void close() throws IOException {
        this.blog.flush();
        this.blog.logSummaryLine("stream closed");
        super.close();
    }
}

