/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.logger;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.layer.logger.BufferedLogger;
import org.silvertunnel_ng.netlib.layer.logger.LoggingInputStream;
import org.silvertunnel_ng.netlib.layer.logger.LoggingOutputStream;
import org.slf4j.Logger;

public class LoggingNetSocket
implements NetSocket {
    private final NetSocket lowerLayerSocket;
    private final Logger summaryLog;
    private final Level summaryLogLevel;
    private final Logger detailLog;
    private final Level detailLogLevel;
    private final boolean logContent;
    private final String topDownLoggingPrefix;
    private final String bottomUpLoggingPrefix;
    private InputStream in;
    private OutputStream out;

    public LoggingNetSocket(NetSocket lowerLayerSocket, Logger summaryLog, Level summaryLogLevel, Logger detailLog, Level detailLogLevel, boolean logContent, String topDownLoggingPrefix, String bottomUpLoggingPrefix) {
        this.lowerLayerSocket = lowerLayerSocket;
        this.summaryLog = summaryLog;
        this.summaryLogLevel = summaryLogLevel;
        this.detailLog = detailLog;
        this.detailLogLevel = detailLogLevel;
        this.logContent = logContent;
        this.topDownLoggingPrefix = topDownLoggingPrefix;
        this.bottomUpLoggingPrefix = bottomUpLoggingPrefix;
    }

    @Override
    public void close() throws IOException {
        this.lowerLayerSocket.close();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            BufferedLogger bufferedLogger = new BufferedLogger(this.summaryLog, this.summaryLogLevel, this.detailLog, this.detailLogLevel, this.logContent, this.bottomUpLoggingPrefix);
            this.in = new LoggingInputStream(this.lowerLayerSocket.getInputStream(), bufferedLogger);
        }
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            BufferedLogger bufferedLogger = new BufferedLogger(this.summaryLog, this.summaryLogLevel, this.detailLog, this.detailLogLevel, this.logContent, this.topDownLoggingPrefix);
            this.out = new LoggingOutputStream(this.lowerLayerSocket.getOutputStream(), bufferedLogger);
        }
        return this.out;
    }

    public String toString() {
        return "LoggingNetSocket(" + this.lowerLayerSocket + ")";
    }
}

