/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.logger;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.NetAddressNameService;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.api.NetLayerStatus;
import org.silvertunnel_ng.netlib.api.NetServerSocket;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.layer.logger.BufferedLogger;
import org.silvertunnel_ng.netlib.layer.logger.LoggingNetSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingNetLayer
implements NetLayer {
    private static Logger defaultLog = LoggerFactory.getLogger(LoggingNetLayer.class);
    private final NetLayer lowerNetLayer;
    private final Logger summaryLog;
    private final Level summaryLogLevel;
    private final Logger detailLog;
    private final Level detailLogLevel;
    private final boolean logContent;
    private final String topDownLoggingPrefix;
    private final String bottomUpLoggingPrefix;
    private static long connectionAttemptsGlobalCounter = 0L;
    private long connectionAttemptsCounter = 0L;
    private long connectionEstablisedCounter = 0L;

    public LoggingNetLayer(NetLayer lowerNetLayer, String loggingPrefix) {
        this(lowerNetLayer, LoggerFactory.getLogger(lowerNetLayer.getClass()), Level.FINE, LoggerFactory.getLogger(lowerNetLayer.getClass()), Level.FINER, true, "v [down] " + loggingPrefix + ": ", "^ [up]   " + loggingPrefix + ": ");
    }

    public LoggingNetLayer(NetLayer lowerNetLayer, Logger summaryLog, Level summaryLogLevel, Logger detailLog, Level detailLogLevel, boolean logContent, String topDownLoggingPrefix, String bottomUpLoggingPrefix) {
        this.lowerNetLayer = lowerNetLayer;
        this.summaryLog = summaryLog;
        this.summaryLogLevel = summaryLogLevel;
        this.detailLog = detailLog;
        this.detailLogLevel = detailLogLevel;
        this.logContent = logContent;
        this.topDownLoggingPrefix = topDownLoggingPrefix;
        this.bottomUpLoggingPrefix = bottomUpLoggingPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket createNetSocket(Map<String, Object> localProperties, NetAddress localAddress, NetAddress remoteAddress) throws IOException {
        String connectionIdStr = "<conn=" + LoggingNetLayer.getNextConnectionAttemptGlobalCounter() + "> ";
        LoggingNetLayer loggingNetLayer = this;
        synchronized (loggingNetLayer) {
            ++this.connectionAttemptsCounter;
        }
        BufferedLogger tmpLog = new BufferedLogger(this.summaryLog, this.summaryLogLevel, this.detailLog, this.detailLogLevel, this.logContent, connectionIdStr + this.topDownLoggingPrefix);
        tmpLog.logSummaryLine("createNetSocket with localProperties=" + localProperties + ", localAddress=" + localAddress + ", remoteAddress=" + remoteAddress);
        NetSocket lowerLayerSocket = this.lowerNetLayer.createNetSocket(localProperties, localAddress, remoteAddress);
        LoggingNetSocket result = new LoggingNetSocket(lowerLayerSocket, this.summaryLog, this.summaryLogLevel, this.detailLog, this.detailLogLevel, this.logContent, connectionIdStr + this.topDownLoggingPrefix, connectionIdStr + this.bottomUpLoggingPrefix);
        tmpLog.logSummaryLine("createNetSocket was successful for lowerLayerSocket=" + lowerLayerSocket);
        LoggingNetLayer loggingNetLayer2 = this;
        synchronized (loggingNetLayer2) {
            ++this.connectionEstablisedCounter;
        }
        return result;
    }

    @Override
    public NetServerSocket createNetServerSocket(Map<String, Object> properties, NetAddress localListenAddress) throws IOException {
        String connectionIdStr = "<server-conn=" + LoggingNetLayer.getNextConnectionAttemptGlobalCounter() + "> ";
        BufferedLogger tmpLog = new BufferedLogger(this.summaryLog, this.summaryLogLevel, this.detailLog, this.detailLogLevel, this.logContent, connectionIdStr + this.topDownLoggingPrefix);
        tmpLog.logSummaryLine("createNetSocket with properties=" + properties + ", localListenAddress=" + localListenAddress);
        return this.lowerNetLayer.createNetServerSocket(properties, localListenAddress);
    }

    protected static synchronized long getNextConnectionAttemptGlobalCounter() {
        if (++connectionAttemptsGlobalCounter < 0L) {
            connectionAttemptsGlobalCounter = 1L;
        }
        return connectionAttemptsGlobalCounter;
    }

    @Override
    public NetLayerStatus getStatus() {
        return this.lowerNetLayer.getStatus();
    }

    @Override
    public void waitUntilReady() {
        this.lowerNetLayer.waitUntilReady();
    }

    @Override
    public void clear() throws IOException {
        this.lowerNetLayer.clear();
    }

    @Override
    public NetAddressNameService getNetAddressNameService() {
        return this.lowerNetLayer.getNetAddressNameService();
    }

    public static synchronized long getConnectionAttemptsGlobalCounter() {
        return connectionAttemptsGlobalCounter;
    }

    public synchronized long getConnectionAttemptsCounter() {
        return this.connectionAttemptsCounter;
    }

    public synchronized long getConnectionEstablisedCounter() {
        return this.connectionEstablisedCounter;
    }
}

