/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.logger;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.silvertunnel_ng.netlib.layer.logger.BufferedLogger;

public class LoggingInputStream
extends FilterInputStream {
    private final BufferedLogger blog;

    protected LoggingInputStream(InputStream is, BufferedLogger bufferedLogger) {
        super(is);
        this.blog = bufferedLogger;
    }

    @Override
    public int read() throws IOException {
        boolean unknownThrowableIsOnTheWay = true;
        int result = 0;
        try {
            result = this.in.read();
            unknownThrowableIsOnTheWay = false;
        }
        catch (IOException e) {
            unknownThrowableIsOnTheWay = false;
            this.blog.flush();
            this.blog.logSummaryLine("throwable detected1: " + e);
            throw e;
        }
        catch (RuntimeException e) {
            unknownThrowableIsOnTheWay = false;
            this.blog.flush();
            this.blog.logSummaryLine("throwable detected2: " + e);
            throw e;
        }
        finally {
            if (unknownThrowableIsOnTheWay) {
                this.blog.flush();
                this.blog.logSummaryLine("throwable detected4");
            }
        }
        this.blog.log((byte)result);
        this.blog.flush();
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        boolean unknownThrowableIsOnTheWay = true;
        int numOfBytes = 0;
        try {
            numOfBytes = this.in.read(b, off, len);
            unknownThrowableIsOnTheWay = false;
        }
        catch (IOException e) {
            unknownThrowableIsOnTheWay = false;
            this.blog.flush();
            this.blog.logSummaryLine("throwable detected: " + e);
            throw e;
        }
        catch (RuntimeException e) {
            unknownThrowableIsOnTheWay = false;
            this.blog.flush();
            this.blog.logSummaryLine("throwable detected: " + e);
            throw e;
        }
        finally {
            if (unknownThrowableIsOnTheWay) {
                this.blog.flush();
                this.blog.logSummaryLine("throwable detected");
            }
        }
        this.blog.log(b, off, numOfBytes);
        this.blog.flush();
        return numOfBytes;
    }

    @Override
    public void close() throws IOException {
        this.blog.flush();
        this.blog.logSummaryLine("stream closed");
        super.close();
    }
}

