/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.logger;

import java.util.logging.Level;
import org.silvertunnel_ng.netlib.util.LogHelper;
import org.slf4j.Logger;

public class BufferedLogger {
    public static final Level LOG_LEVEL_NULL = Level.OFF;
    public static final Level LOG_LEVEL_DEBUG = Level.FINE;
    public static final Level LOG_LEVEL_INFO = Level.INFO;
    private static final char SPECIAL_CHAR = '?';
    private final Logger summaryLog;
    private final Level summaryLogLevel;
    private final Logger detailLog;
    private final Level detailLogLevel;
    private final boolean logSingleBytes;
    private final String logMessagePrefix;
    private StringBuffer buffer = new StringBuffer();
    int byteCount = 0;

    public BufferedLogger(Logger summaryLog, Level summaryLogLevel, Logger detailLog, Level detailLogLevel, boolean logSingleBytes, String logMessagePrefix) {
        this.summaryLog = summaryLog;
        this.summaryLogLevel = summaryLogLevel;
        this.detailLog = detailLog;
        this.detailLogLevel = detailLogLevel;
        this.logSingleBytes = logSingleBytes;
        this.logMessagePrefix = logMessagePrefix;
    }

    public void log(byte b) {
        if (this.logSingleBytes && LogHelper.isLoggable(this.detailLog, this.detailLogLevel)) {
            char c = (char)b;
            if (c >= ' ' && c <= '\u007f') {
                this.logAndCount(c);
            } else {
                this.logAndCount('?');
                int i = b < 0 ? 256 + b : b;
                String hex = Integer.toHexString(i);
                if (hex.length() < 2) {
                    this.logAndDoNotCount("0");
                }
                this.logAndDoNotCount(hex);
            }
        } else {
            ++this.byteCount;
        }
    }

    public void log(byte[] bytes, int offset, int numOfBytes) {
        if (this.logSingleBytes && LogHelper.isLoggable(this.detailLog, this.detailLogLevel)) {
            int len = bytes.length;
            for (int i = 0; i < numOfBytes; ++i) {
                int idx = offset + i;
                if (idx >= len) continue;
                this.log(bytes[idx]);
            }
        } else {
            this.byteCount += numOfBytes;
        }
    }

    private void logAndCount(char c) {
        this.buffer.append(c);
        ++this.byteCount;
    }

    private void logAndDoNotCount(String s) {
        this.buffer.append(s);
    }

    public void flush() {
        if (this.buffer.length() > 0) {
            if (LogHelper.isLoggable(this.detailLog, this.detailLogLevel)) {
                String msg = this.byteCount + " bytes \"" + this.buffer.toString() + "\"";
                this.logDetailLine(msg);
            }
            this.byteCount = 0;
            this.buffer = new StringBuffer();
        }
        if (this.byteCount > 0) {
            this.logDetailLine(this.byteCount + " bytes");
            this.byteCount = 0;
            this.buffer = new StringBuffer();
        }
    }

    public void logSummaryLine(String msg) {
        LogHelper.logLine(this.summaryLog, this.summaryLogLevel, msg, false, this.logMessagePrefix);
    }

    public void logDetailLine(String msg) {
        LogHelper.logLine(this.detailLog, this.detailLogLevel, msg, false, this.logMessagePrefix);
    }

    public boolean isLogSingleBytesEnabled() {
        return this.logSingleBytes;
    }
}

