/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.control;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.silvertunnel_ng.netlib.layer.control.ControlNetSocket;
import org.silvertunnel_ng.netlib.layer.control.ControlParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlNetSocketThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ControlNetSocketThread.class);
    private static ControlNetSocketThread instance;
    private final Map<ControlNetSocket, ControlParameters> sockets = Collections.synchronizedMap(new WeakHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startControlingControlNetSocket(ControlNetSocket socket, ControlParameters parameters) {
        Map<ControlNetSocket, ControlParameters> map = ControlNetSocketThread.instance.sockets;
        synchronized (map) {
            ControlNetSocketThread.instance.sockets.put(socket, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopControlingControlNetSocket(ControlNetSocket socket) {
        Map<ControlNetSocket, ControlParameters> map = ControlNetSocketThread.instance.sockets;
        synchronized (map) {
            ControlNetSocketThread.instance.sockets.remove(socket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            HashMap<ControlNetSocket, String> socketsToRemoveFromChecklist = new HashMap<ControlNetSocket, String>();
            Map<ControlNetSocket, ControlParameters> map = this.sockets;
            synchronized (map) {
                for (Map.Entry<ControlNetSocket, ControlParameters> entry : this.sockets.entrySet()) {
                    String timeoutText = this.checkSingleSocketOnce(entry.getKey(), entry.getValue());
                    if (timeoutText == null) continue;
                    socketsToRemoveFromChecklist.put(entry.getKey(), timeoutText);
                }
                for (Map.Entry<ControlNetSocket, ControlParameters> entry : socketsToRemoveFromChecklist.entrySet()) {
                    this.sockets.remove(entry.getKey());
                }
            }
            for (Map.Entry e : socketsToRemoveFromChecklist.entrySet()) {
                this.sendTimeoutToSingleSocket((ControlNetSocket)e.getKey(), (String)e.getValue());
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                LOG.debug("got IterruptedException : {}", (Object)e.getMessage(), (Object)e);
                continue;
            }
            break;
        }
    }

    private String checkSingleSocketOnce(ControlNetSocket socket, ControlParameters parameters) {
        if (parameters.getOverallTimeoutMillis() > 0L && socket.getOverallMillis() > parameters.getOverallTimeoutMillis()) {
            return "overall timeout reached";
        }
        if (parameters.getThroughputTimeframeMillis() > 0L && socket.getCurrentTimeframeMillis() >= parameters.getThroughputTimeframeMillis()) {
            long bytes = socket.getCurrentTimeframeStartInputOutputBytesAndStartNewTimeframe();
            if (parameters.getThroughputTimeframeMinBytes() > 0L && bytes < parameters.getThroughputTimeframeMinBytes()) {
                return "throughput is too low";
            }
        }
        return null;
    }

    private void sendTimeoutToSingleSocket(ControlNetSocket socket, String msg) {
        LOG.info("send timeout to " + socket + ": " + msg);
        try {
            InterruptedIOException exceptionToBeThrownBySockets = new InterruptedIOException("Stream of ControlNetLayer closed because of: " + msg);
            socket.setInterruptedIOException(exceptionToBeThrownBySockets);
            socket.close();
        }
        catch (IOException e) {
            LOG.debug("IOException while calling close() (want to close because of: {})", (Object)msg, (Object)e);
        }
        catch (Exception e) {
            LOG.info("Exception while calling close() (want to close because of: {})", (Object)msg, (Object)e);
        }
    }

    static {
        try {
            instance = new ControlNetSocketThread();
            instance.setName("ControlNetSocketThread");
            instance.setDaemon(true);
            instance.start();
            LOG.info("ControlNetSocketThread instance started");
        }
        catch (Throwable t) {
            LOG.error("could not construct class ControlNetSocketThread", t);
        }
    }
}

