/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.layer.control;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.layer.control.ControlInputStream;
import org.silvertunnel_ng.netlib.layer.control.ControlNetSocketThread;
import org.silvertunnel_ng.netlib.layer.control.ControlOutputStream;
import org.silvertunnel_ng.netlib.layer.control.ControlParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlNetSocket
implements NetSocket {
    private static final Logger LOG = LoggerFactory.getLogger(ControlNetSocket.class);
    private final NetSocket lowerLayerSocket;
    private InputStream in;
    private OutputStream out;
    private long lastActivity;
    private final long startDate;
    private long connectDate;
    private long currentTimeframeStartDate;
    private long currentTimeframeStartInputOutputBytes;
    private long inputBytes;
    private long outputBytes;
    private InterruptedIOException interruptedIOException;

    public ControlNetSocket(NetSocket lowerLayerSocket, ControlParameters parameters) {
        this.currentTimeframeStartDate = this.startDate = System.currentTimeMillis();
        this.currentTimeframeStartInputOutputBytes = 0L;
        this.lowerLayerSocket = lowerLayerSocket;
        this.setLastActivity();
        ControlNetSocketThread.startControlingControlNetSocket(this, parameters);
    }

    protected synchronized void addInputBytes(int bytes) {
        this.inputBytes += (long)bytes;
    }

    protected synchronized void addOutputBytes(int bytes) {
        this.outputBytes += (long)bytes;
    }

    protected void setLastActivity(long lastActivity) {
        this.lastActivity = lastActivity;
    }

    protected void setLastActivity() {
        this.setLastActivity(System.currentTimeMillis());
    }

    public long getCurrentTimeframeMillis() {
        return System.currentTimeMillis() - this.currentTimeframeStartDate;
    }

    public long getOverallMillis() {
        return System.currentTimeMillis() - this.startDate;
    }

    protected synchronized long getCurrentTimeframeStartInputOutputBytesAndStartNewTimeframe() {
        long result = this.getInputOutputBytes() - this.currentTimeframeStartInputOutputBytes;
        this.currentTimeframeStartInputOutputBytes = this.getInputOutputBytes();
        this.currentTimeframeStartDate = System.currentTimeMillis();
        return result;
    }

    @Override
    public void close() throws IOException {
        this.lowerLayerSocket.close();
        ControlNetSocketThread.stopControlingControlNetSocket(this);
        this.setLastActivity();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new ControlInputStream(this.lowerLayerSocket.getInputStream(), this);
        }
        this.setLastActivity();
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new ControlOutputStream(this.lowerLayerSocket.getOutputStream(), this);
        }
        this.setLastActivity();
        return this.out;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        return "ControlNetSocket(" + this.lowerLayerSocket + ")";
    }

    protected void setInterruptedIOException(InterruptedIOException interruptedIOException) {
        this.interruptedIOException = interruptedIOException;
    }

    protected void throwInterruptedIOExceptionIfNecessary() throws InterruptedIOException {
        if (this.interruptedIOException != null) {
            throw this.interruptedIOException;
        }
    }

    public long getStartDate() {
        return this.startDate;
    }

    public long getConnectDate() {
        return this.connectDate;
    }

    public long getCurrentTimeframeStartDate() {
        return this.currentTimeframeStartDate;
    }

    public long getCurrentTimeframeStartInputOutputBytes() {
        return this.currentTimeframeStartInputOutputBytes;
    }

    public long getInputBytes() {
        return this.inputBytes;
    }

    public long getOutputBytes() {
        return this.outputBytes;
    }

    public long getInputOutputBytes() {
        return this.inputBytes + this.outputBytes;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }
}

