/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.api.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.util.IpNetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpipNetAddress
implements NetAddress {
    private static final Logger LOG = LoggerFactory.getLogger(TcpipNetAddress.class);
    private String hostname;
    private byte[] ipaddress;
    private int port;
    private static final String DEFAULT_HOSTNAME = "0.0.0.0";
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;
    private static Pattern ip4Pattern;

    public TcpipNetAddress(String hostnameOrIpaddressAndTcpPort) throws IllegalArgumentException {
        String portStr;
        if (hostnameOrIpaddressAndTcpPort.contains(":")) {
            int idx = hostnameOrIpaddressAndTcpPort.lastIndexOf(58);
            this.hostname = hostnameOrIpaddressAndTcpPort.substring(0, idx);
            if (this.hostname.length() == 0) {
                this.hostname = DEFAULT_HOSTNAME;
            }
            try {
                Matcher m = ip4Pattern.matcher(this.hostname);
                if (m.find()) {
                    this.ipaddress = new byte[4];
                    for (int i = 0; i < 4; ++i) {
                        this.ipaddress[i] = (byte)Integer.parseInt(m.group(i + 1));
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("could not parse IPv4 address=" + this.hostname);
            }
            portStr = hostnameOrIpaddressAndTcpPort.substring(idx + 1);
        } else {
            this.hostname = DEFAULT_HOSTNAME;
            portStr = hostnameOrIpaddressAndTcpPort;
        }
        try {
            this.port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("port could not be parsed of nameOrIpAddressAndTcpPort=" + hostnameOrIpaddressAndTcpPort);
        }
        this.checkThis();
    }

    public TcpipNetAddress(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    public TcpipNetAddress(byte[] ipaddress, int port) throws IllegalArgumentException {
        if (ipaddress != null) {
            if (ipaddress.length == 4) {
                this.ipaddress = ipaddress;
            } else if (ipaddress.length == 16) {
                this.ipaddress = ipaddress;
            } else {
                throw new IllegalArgumentException("invalid IP address length (" + ipaddress.length + " bytes )");
            }
        }
        this.port = port;
    }

    public TcpipNetAddress(IpNetAddress ipaddress, int port) throws IllegalArgumentException {
        this(ipaddress.getIpaddress(), port);
    }

    public TcpipNetAddress(String hostname, byte[] ipaddress, int port) throws IllegalArgumentException {
        this.hostname = hostname;
        if (ipaddress != null) {
            if (ipaddress.length == 4) {
                this.ipaddress = ipaddress;
            } else if (ipaddress.length == 16) {
                this.ipaddress = ipaddress;
            } else {
                throw new IllegalArgumentException("invalid IP address length (" + ipaddress.length + " bytes )");
            }
        }
        this.port = port;
    }

    public TcpipNetAddress(String hostname, InetAddress inetAddress, int port) throws IllegalArgumentException {
        this.hostname = hostname;
        if (inetAddress != null) {
            if (inetAddress instanceof Inet4Address) {
                this.ipaddress = ((Inet4Address)inetAddress).getAddress();
            } else if (this.ipaddress.length == 16) {
                this.ipaddress = ((Inet6Address)inetAddress).getAddress();
            } else {
                throw new IllegalArgumentException("invalid inet address=" + inetAddress);
            }
        }
        this.port = port;
    }

    public TcpipNetAddress(InetAddress inetAddress, int port) throws IllegalArgumentException {
        if (inetAddress != null) {
            if (inetAddress instanceof Inet4Address) {
                this.ipaddress = ((Inet4Address)inetAddress).getAddress();
            } else if (this.ipaddress.length == 16) {
                this.ipaddress = ((Inet6Address)inetAddress).getAddress();
            } else {
                throw new IllegalArgumentException("invalid inet address=" + inetAddress);
            }
        }
        this.port = port;
    }

    private void checkThis() throws IllegalArgumentException {
        if (this.port < 0 || this.port > 65535) {
            throw new IllegalArgumentException("port=" + this.port + " is out of range");
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getHostnameAndPort() {
        return (this.hostname == null ? "" : this.hostname) + ":" + this.port;
    }

    public byte[] getIpaddress() {
        return this.ipaddress;
    }

    public IpNetAddress getIpNetAddress() {
        return new IpNetAddress(this.ipaddress);
    }

    public String getIpaddressAsString() {
        if (this.ipaddress == null) {
            return null;
        }
        if (this.ipaddress.length == 4) {
            return this.getByteAsNonnegativeInt(this.ipaddress[0]) + "." + this.getByteAsNonnegativeInt(this.ipaddress[1]) + "." + this.getByteAsNonnegativeInt(this.ipaddress[2]) + "." + this.getByteAsNonnegativeInt(this.ipaddress[3]);
        }
        StringBuffer result = new StringBuffer();
        return ":IPv6:" + this.ipaddress;
    }

    private int getByteAsNonnegativeInt(byte signedByte) {
        if (signedByte >= 0) {
            return signedByte;
        }
        return 256 + signedByte;
    }

    public String getIpaddressAndPort() {
        String ipaddressStr = this.getIpaddressAsString();
        return (ipaddressStr == null ? "" : ipaddressStr) + ":" + this.port;
    }

    public InetAddress getIpaddressAsInetAddress() {
        if (this.ipaddress == null) {
            return null;
        }
        try {
            return InetAddress.getByAddress(this.ipaddress);
        }
        catch (UnknownHostException e) {
            LOG.warn("could not convert into InetAddress: {}", (Object)this.toString(), (Object)e);
            return null;
        }
    }

    public String getHostnameOrIpaddress() {
        if (this.hostname != null) {
            return this.hostname;
        }
        return this.getIpaddressAsString();
    }

    public int getPort() {
        return this.port;
    }

    protected String getId() {
        return "TcpipNetAddress(hostname=" + this.hostname + ",ipaddress=" + this.getIpaddressAsString() + ",port=" + this.port + ")";
    }

    public String toString() {
        return this.getId();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TcpipNetAddress)) {
            return false;
        }
        TcpipNetAddress other = (TcpipNetAddress)obj;
        if (this.hostname == null) {
            if (other.hostname != null) {
                return false;
            }
        } else {
            if (other.hostname == null) {
                return false;
            }
            if (!this.hostname.equals(other.hostname)) {
                return false;
            }
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.ipaddress == null) {
            if (other.ipaddress != null) {
                return false;
            }
        } else {
            if (other.ipaddress == null) {
                return false;
            }
            if (!Arrays.equals(this.ipaddress, other.ipaddress)) {
                return false;
            }
        }
        return true;
    }

    static {
        try {
            ip4Pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)", 35);
        }
        catch (Exception e) {
            LOG.error("could not initialze class AuthorityKeyCertificate", (Throwable)e);
        }
    }
}

