/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.api.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum JavaVersion {
    JAVA_1_5("JAVA_1_5"),
    JAVA_1_6("JAVA_1_6"),
    JAVA_1_7("JAVA_1_7"),
    UNKNOWN("UNKNOWN");

    private final String title;
    private static final Logger LOG;
    private static JavaVersion javaVersion;

    private JavaVersion(String title) {
        this.title = title;
    }

    public String toString() {
        return this.title;
    }

    public static JavaVersion getJavaVersion() {
        if (javaVersion == null) {
            String jv = System.getProperty("java.specification.version");
            LOG.debug("system prop jv={}", (Object)jv);
            javaVersion = "1.5".equals(jv) ? JAVA_1_5 : ("1.6".equals(jv) ? JAVA_1_6 : ("1.7".equals(jv) ? JAVA_1_7 : UNKNOWN));
            LOG.debug("determined Java Version: {}", (Object)javaVersion);
        }
        return javaVersion;
    }

    static {
        LOG = LoggerFactory.getLogger(JavaVersion.class);
    }
}

