/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.api.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.silvertunnel_ng.netlib.api.NetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpNetAddress
implements NetAddress {
    private static final Logger LOG = LoggerFactory.getLogger(IpNetAddress.class);
    private byte[] ipaddress;
    private static Pattern ip4Pattern;

    public IpNetAddress(String ipAddressStr) throws IllegalArgumentException {
        try {
            Matcher m = ip4Pattern.matcher(ipAddressStr);
            if (m.find()) {
                this.ipaddress = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    this.ipaddress[i] = (byte)Integer.parseInt(m.group(i + 1));
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not parse IPv4 address=" + ipAddressStr);
        }
    }

    public IpNetAddress(byte[] ipaddress) throws IllegalArgumentException {
        if (ipaddress != null) {
            if (ipaddress.length == 4) {
                this.ipaddress = ipaddress;
            } else if (ipaddress.length == 16) {
                this.ipaddress = ipaddress;
            } else {
                throw new IllegalArgumentException("invalid IP address length (" + ipaddress.length + " bytes )");
            }
        }
    }

    public IpNetAddress(InetAddress inetAddress) throws IllegalArgumentException {
        if (inetAddress != null) {
            if (inetAddress instanceof Inet4Address) {
                this.ipaddress = ((Inet4Address)inetAddress).getAddress();
            } else if (this.ipaddress.length == 16) {
                this.ipaddress = ((Inet6Address)inetAddress).getAddress();
            } else {
                throw new IllegalArgumentException("invalid inet address=" + inetAddress);
            }
        }
    }

    public byte[] getIpaddress() {
        return this.ipaddress;
    }

    public String getIpaddressAsString() {
        if (this.ipaddress == null) {
            return null;
        }
        if (this.ipaddress.length == 4) {
            return this.getByteAsNonnegativeInt(this.ipaddress[0]) + "." + this.getByteAsNonnegativeInt(this.ipaddress[1]) + "." + this.getByteAsNonnegativeInt(this.ipaddress[2]) + "." + this.getByteAsNonnegativeInt(this.ipaddress[3]);
        }
        return ":IPv6:" + this.ipaddress;
    }

    private int getByteAsNonnegativeInt(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    public InetAddress getIpaddressAsInetAddress() {
        if (this.ipaddress == null) {
            return null;
        }
        try {
            return InetAddress.getByAddress(this.ipaddress);
        }
        catch (UnknownHostException e) {
            LOG.warn("could not convert into InetAddress: {}", (Object)this.toString(), (Object)e);
            return null;
        }
    }

    protected String getId() {
        return "IpNetAddress(ipaddress=" + this.getIpaddressAsString() + ")";
    }

    public String toString() {
        return this.getId();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IpNetAddress)) {
            return false;
        }
        IpNetAddress other = (IpNetAddress)obj;
        return this.getId().equals(other.getId());
    }

    static {
        try {
            ip4Pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)", 35);
        }
        catch (Exception e) {
            LOG.error("could not initialze class AuthorityKeyCertificate", (Throwable)e);
        }
    }
}

