/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.api.service;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetlibVersion {
    private static final Logger LOG = LoggerFactory.getLogger(NetlibVersion.class);
    private static final Logger LOGNETLIB = LoggerFactory.getLogger((String)"org.silvertunnel_ng.netlib");
    private static NetlibVersion instance;
    private static final String VERSION_PROPERTIES = "/org/silvertunnel_ng/netlib/version.properties";
    private String netlibVersionInfo = "unknown";
    private static NetlibVersion info;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetlibVersion getInstance() {
        if (instance != null) return instance;
        Class<NetlibVersion> clazz = NetlibVersion.class;
        synchronized (NetlibVersion.class) {
            if (instance != null) return instance;
            instance = new NetlibVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private NetlibVersion() {
        try {
            InputStream in = this.getClass().getResourceAsStream(VERSION_PROPERTIES);
            Properties props = new Properties();
            props.load(in);
            this.netlibVersionInfo = props.getProperty("netlib.version.info");
        }
        catch (Exception e) {
            LOG.error("error while initializing NetlibStartInfo", (Throwable)e);
        }
        LOGNETLIB.info("Welcome to silvertunnel-ng.org Netlib (version " + this.netlibVersionInfo + ")");
    }

    public String getNetlibVersionInfo() {
        return this.netlibVersionInfo;
    }

    static {
        info = NetlibVersion.getInstance();
    }
}

