/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.api.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.silvertunnel_ng.netlib.api.impl.SocketTimeoutInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SocketTimeoutInputStreamThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(SocketTimeoutInputStreamThread.class);
    private final SocketTimeoutInputStream stis;
    private final InputStream wrappedInputStream;
    private static final long WAIT_TIMEOUT_MS = 60000L;
    private static final DateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    SocketTimeoutInputStreamThread(SocketTimeoutInputStream socketTimeoutInputStream, InputStream wrappedInputStream) {
        super(SocketTimeoutInputStreamThread.createThreadName());
        this.stis = socketTimeoutInputStream;
        this.wrappedInputStream = wrappedInputStream;
        this.setDaemon(true);
    }

    private static final String createThreadName() {
        return Thread.currentThread().getName() + " - SocketTimeoutInputStreamThread (created=" + DF.format(new Date()) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        SocketTimeoutInputStream socketTimeoutInputStream;
        try {
            this.copyBytesFromInputStreamToBuffer();
            return;
        }
        catch (IOException e) {
            socketTimeoutInputStream = this.stis;
            synchronized (socketTimeoutInputStream) {
                this.stis.lastPendingIOException = e;
                return;
            }
        }
        finally {
            this.waitUntilClosed();
            try {
                this.wrappedInputStream.close();
            }
            catch (IOException e) {
                socketTimeoutInputStream = this.stis;
                synchronized (socketTimeoutInputStream) {
                    this.stis.lastPendingIOException = e;
                }
            }
            finally {
                SocketTimeoutInputStream socketTimeoutInputStream2 = this.stis;
                synchronized (socketTimeoutInputStream2) {
                    this.stis.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilClosed() {
        SocketTimeoutInputStream socketTimeoutInputStream = this.stis;
        synchronized (socketTimeoutInputStream) {
            this.stis.waitingForClose = true;
            this.stis.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBytesFromInputStreamToBuffer() throws IOException {
        while (true) {
            int count;
            int len;
            int offset;
            SocketTimeoutInputStream socketTimeoutInputStream = this.stis;
            synchronized (socketTimeoutInputStream) {
                while (this.stis.bufferLen == this.stis.buffer.length) {
                    if (this.stis.closeRequestedByServiceUser) {
                        return;
                    }
                    this.waitForRead();
                }
                offset = (this.stis.bufferHead + this.stis.bufferLen) % this.stis.buffer.length;
                len = (this.stis.bufferHead > offset ? this.stis.bufferHead : this.stis.buffer.length) - offset;
            }
            try {
                count = this.wrappedInputStream.read(this.stis.buffer, offset, len);
                if (count == -1) {
                    return;
                }
            }
            catch (InterruptedIOException e) {
                count = e.bytesTransferred;
            }
            SocketTimeoutInputStream socketTimeoutInputStream2 = this.stis;
            synchronized (socketTimeoutInputStream2) {
                this.stis.bufferLen += count;
                this.stis.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRead() {
        SocketTimeoutInputStream socketTimeoutInputStream = this.stis;
        synchronized (socketTimeoutInputStream) {
            try {
                this.stis.wait(60000L);
            }
            catch (InterruptedException e) {
                this.stis.closeRequestedByServiceUser = true;
            }
        }
    }
}

