/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.api.impl;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import org.silvertunnel_ng.netlib.api.impl.SocketTimeoutInputStreamThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketTimeoutInputStream
extends FilterInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(SocketTimeoutInputStream.class);
    private long timeout;
    volatile boolean closeRequestedByServiceUser;
    volatile boolean waitingForClose;
    private final SocketTimeoutInputStreamThread thread;
    private static final int BUFFER_SIZE = 4096;
    final transient byte[] buffer = new byte[4096];
    transient int bufferHead = 0;
    transient int bufferLen = 0;
    volatile IOException lastPendingIOException;

    public SocketTimeoutInputStream(InputStream in, long timeout) {
        super(in);
        this.timeout = timeout;
        this.thread = new SocketTimeoutInputStreamThread(this, in);
        this.thread.start();
    }

    public synchronized void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SocketTimeoutException, IOException {
        SocketTimeoutInputStreamThread oldThread;
        super.close();
        SocketTimeoutInputStream socketTimeoutInputStream = this;
        synchronized (socketTimeoutInputStream) {
            if (this.thread == null) {
                return;
            }
            oldThread = this.thread;
            this.closeRequestedByServiceUser = true;
            this.thread.interrupt();
            this.throwLastPendingIOException();
        }
        if (this.timeout == -1L) {
            return;
        }
        try {
            oldThread.join(this.timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        socketTimeoutInputStream = this;
        synchronized (socketTimeoutInputStream) {
            this.throwLastPendingIOException();
            if (this.thread != null) {
                throw new SocketTimeoutException();
            }
        }
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.bufferLen == 0) {
            this.throwLastPendingIOException();
        }
        return this.bufferLen > 0 ? this.bufferLen : 0;
    }

    @Override
    public synchronized int read() throws IOException {
        boolean ONE = true;
        byte[] buffer1 = new byte[1];
        int len = this.read(buffer1, 0, 1);
        if (len < 1) {
            return -1;
        }
        return buffer1[0] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        if (!this.waitUntilBufferIsFilled()) {
            return -1;
        }
        int pos = off;
        if (len > this.bufferLen) {
            len = this.bufferLen;
        }
        while (len-- > 0) {
            buf[pos++] = this.buffer[this.bufferHead++];
            if (this.bufferHead == this.buffer.length) {
                this.bufferHead = 0;
            }
            --this.bufferLen;
        }
        this.notify();
        return pos - off;
    }

    @Override
    public synchronized long skip(long count) throws IOException {
        long amount = 0L;
        try {
            while (this.waitUntilBufferIsFilled()) {
                int skip = (int)Math.min(count - amount, (long)this.bufferLen);
                this.bufferHead = (this.bufferHead + skip) % this.buffer.length;
                this.bufferLen -= skip;
                if ((amount += (long)skip) < count) continue;
                break;
            }
        }
        catch (SocketTimeoutException e) {
            e.bytesTransferred = (int)amount;
            throw e;
        }
        this.notify();
        return amount;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private boolean waitUntilBufferIsFilled() throws IOException, SocketTimeoutException {
        if (this.bufferLen != 0) {
            return true;
        }
        this.throwLastPendingIOException();
        if (this.waitingForClose) {
            return false;
        }
        this.notify();
        try {
            this.wait(this.timeout);
        }
        catch (InterruptedException e) {
            LOG.debug("got InterruptedException : {}", (Object)e, (Object)e);
            Thread.currentThread().interrupt();
        }
        this.throwLastPendingIOException();
        if (this.bufferLen != 0) {
            return true;
        }
        if (this.waitingForClose) {
            return false;
        }
        throw new SocketTimeoutException();
    }

    private void throwLastPendingIOException() throws IOException {
        if (this.lastPendingIOException != null) {
            IOException e = this.lastPendingIOException;
            this.lastPendingIOException = null;
            throw e;
        }
    }
}

