/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.api.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.util.HashMap;
import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.api.impl.SocketTimeoutInputStream;
import org.silvertunnel_ng.netlib.api.util.TcpipNetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetSocket2SocketImpl
extends SocketImpl {
    private static final Logger LOG = LoggerFactory.getLogger(NetSocket2SocketImpl.class);
    public static final String TCPIP_NET_LAYER_TIMEOUT_IN_MS = "TcpipNetLayer.timeoutInMs";
    private NetSocket netSocket;
    private NetLayer netLayer;
    private final int DEFAULT_INPUTSTREAM_TIMEOUT = 60000;
    private int inputStreamTimeout = 60000;
    private final Boolean DEFAULT_TCP_NODELAY;
    private Boolean tcpNodelay = this.DEFAULT_TCP_NODELAY = Boolean.valueOf(true);
    private final Integer DEFAULT_SO_LINGER;
    private Integer soLinger = this.DEFAULT_SO_LINGER = Integer.valueOf(0);
    private SocketTimeoutInputStream inputStream;

    public NetSocket2SocketImpl(NetSocket netSocket) {
        this.netSocket = netSocket;
    }

    public NetSocket2SocketImpl(NetLayer netLayer) {
        this.netLayer = netLayer;
    }

    public void setNetSocket(NetSocket netSocket) {
        this.netSocket = netSocket;
    }

    @Override
    protected void accept(SocketImpl arg0) throws IOException {
        LOG.warn("method empty/not implemented", new Throwable("method empty/not implemented"));
    }

    @Override
    protected int available() throws IOException {
        LOG.warn("method empty/not implemented", new Throwable("method empty/not implemented"));
        return 0;
    }

    @Override
    protected void bind(InetAddress arg0, int arg1) throws IOException {
    }

    @Override
    protected void close() throws IOException {
        if (this.netSocket != null) {
            this.netSocket.close();
        } else {
            LOG.info("close() with netSocket=null", new Throwable("Just to dump a trace"));
        }
    }

    @Override
    protected void connect(String remoteHost, int port) throws IOException {
        this.connect(new InetSocketAddress(remoteHost, port), 0);
    }

    @Override
    protected void connect(InetAddress remoteAddress, int port) throws IOException {
        this.connect(new InetSocketAddress(remoteAddress, port), 0);
    }

    @Override
    protected void connect(SocketAddress remoteAddress, int timeoutInMs) throws IOException {
        if (this.netSocket != null) {
            return;
        }
        if (this.netLayer == null) {
            throw new IllegalStateException("netLayer not set");
        }
        LOG.debug("method empty implemented");
        if (remoteAddress == null || !(remoteAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress remoteInetSocketAddress = (InetSocketAddress)remoteAddress;
        TcpipNetAddress remoteNetAddress = remoteInetSocketAddress.isUnresolved() ? new TcpipNetAddress(remoteInetSocketAddress.getHostName(), remoteInetSocketAddress.getPort()) : new TcpipNetAddress(remoteInetSocketAddress.getAddress().getHostAddress(), remoteInetSocketAddress.getPort());
        HashMap<String, Object> localProperties = new HashMap<String, Object>();
        localProperties.put(TCPIP_NET_LAYER_TIMEOUT_IN_MS, timeoutInMs);
        NetAddress localNetAddress = null;
        this.netSocket = this.netLayer.createNetSocket(localProperties, localNetAddress, remoteNetAddress);
    }

    @Override
    protected void create(boolean arg0) throws IOException {
    }

    @Override
    protected synchronized InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new SocketTimeoutInputStream(this.netSocket.getInputStream(), this.inputStreamTimeout);
        }
        return this.inputStream;
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        return this.netSocket.getOutputStream();
    }

    @Override
    protected void listen(int arg0) throws IOException {
        LOG.warn("method empty/not implemented", new Throwable("method empty/not implemented"));
    }

    @Override
    protected void sendUrgentData(int arg0) throws IOException {
        LOG.warn("method empty/not implemented", new Throwable("method empty/not implemented"));
    }

    @Override
    public Object getOption(int key) throws SocketException {
        if (key == 4102) {
            return this.inputStreamTimeout;
        }
        if (key == 1) {
            return this.tcpNodelay;
        }
        if (key == 128) {
            return this.soLinger;
        }
        String msg = "no implementation for getOption(" + key + "). List of all options in java.net.SocketOptions.";
        if (LOG.isDebugEnabled()) {
            LOG.debug(msg, new Throwable("method not completely implemented"));
        } else {
            LOG.info(msg + " - Log with level=debug to get call hierarchy.");
        }
        return null;
    }

    @Override
    public synchronized void setOption(int key, Object value) throws SocketException {
        LOG.debug("setOption(key={},value={})", (Object)key, value);
        if (key == 4102) {
            if (value instanceof Integer) {
                this.inputStreamTimeout = (Integer)value;
                if (this.inputStream != null) {
                    this.inputStream.setTimeout(this.inputStreamTimeout);
                }
            } else {
                LOG.warn("ignored value of wrong type of setOption(key={},value={}). List of all options in java.net.SocketOptions.", (Object)key, value);
            }
            return;
        }
        if (key == 1) {
            if (value instanceof Boolean) {
                this.tcpNodelay = (Boolean)value;
            } else {
                LOG.warn("ignored value of wrong type of setOption(key={},value={}). List of all options in java.net.SocketOptions.", (Object)key, value);
            }
            return;
        }
        if (key == 4102) {
            if (value instanceof Integer) {
                this.soLinger = (Integer)value;
            } else {
                LOG.warn("ignored value of wrong type of setOption(key={},value={}). List of all options in java.net.SocketOptions.", (Object)key, value);
            }
            return;
        }
        String msg = "no implementation for setOption(key=" + key + ",value=" + value + "). List of all options in java.net.SocketOptions.";
        if (LOG.isDebugEnabled()) {
            LOG.debug(msg, new Throwable("method not completely implemented"));
        } else {
            LOG.warn(msg + " Log with level=debug to get call hierarchy.");
        }
    }
}

