/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.api;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.api.NetLayerFactory;
import org.silvertunnel_ng.netlib.api.NetLayerIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetFactory
implements NetLayerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NetFactory.class);
    public static final String NETFACTORY_MAPPING_PROPERTIES = "/org/silvertunnel_ng/netlib/api/netfactory_mapping.properties";
    private final Map<NetLayerIDs, NetLayer> netLayerRepository = new HashMap<NetLayerIDs, NetLayer>();
    private static NetFactory instance = new NetFactory();

    public static NetFactory getInstance() {
        return instance;
    }

    public final synchronized void registerNetLayer(NetLayerIDs netLayerId, NetLayer netLayer) {
        this.netLayerRepository.put(netLayerId, netLayer);
        LOG.debug("registerNetLayer with netLayerId={}", (Object)netLayerId);
    }

    public final synchronized void clearRegisteredNetLayers() {
        this.netLayerRepository.clear();
    }

    @Override
    public synchronized NetLayer getNetLayerById(NetLayerIDs netLayerId) {
        NetLayer result = this.netLayerRepository.get((Object)netLayerId);
        if (result == null) {
            try {
                NetLayerFactory factory = this.getNetLayerFactoryByNetLayerID(netLayerId);
                if (factory != null && (result = factory.getNetLayerById(netLayerId)) != null) {
                    this.registerNetLayer(netLayerId, result);
                }
            }
            catch (Exception e) {
                LOG.error("could not create NetLayer of {}", (Object)netLayerId, (Object)e);
            }
        }
        return result;
    }

    private NetLayerFactory getNetLayerFactoryByNetLayerID(NetLayerIDs netLayerId) {
        try {
            InputStream in = this.getClass().getResourceAsStream(NETFACTORY_MAPPING_PROPERTIES);
            Properties mapping = new Properties();
            mapping.load(in);
            String netLayerFactoryClassName = mapping.getProperty(netLayerId.getValue());
            Class<?> clazz = Class.forName(netLayerFactoryClassName);
            Constructor<?> c = clazz.getConstructor(new Class[0]);
            NetLayerFactory result = (NetLayerFactory)c.newInstance(new Object[0]);
            return result;
        }
        catch (Exception e) {
            LOG.error("could not create NetLayerFactory of {}", (Object)netLayerId, (Object)e);
            return null;
        }
    }
}

