/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.adapter.url.impl.net.https;

import java.io.IOException;
import java.net.Proxy;
import java.net.SecureCacheResponse;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.Handler;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.HttpClient;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.HttpURLConnection;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.https.HttpsClient;
import org.silvertunnel_ng.netlib.api.NetLayer;

public class HttpsURLConnection
extends HttpURLConnection {
    protected HttpsURLConnection(NetLayer lowerNetLayer, URL url, Handler handler) throws IOException {
        this(lowerNetLayer, url, null, handler);
    }

    protected HttpsURLConnection(NetLayer lowerNetLayer, URL url, Proxy p, Handler handler) throws IOException {
        super(lowerNetLayer, url, p, handler);
    }

    @Override
    public void setNewClient(URL url) throws IOException {
        this.setNewClient(url, false);
    }

    @Override
    public void setNewClient(URL url, boolean useCache) throws IOException {
        this.http = HttpsClient.New(this.lowerNetLayer, url, null, useCache);
    }

    @Override
    public void setProxiedClient(URL url, String proxyHost, int proxyPort) throws IOException {
        this.setProxiedClient(url, proxyHost, proxyPort, false);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean conn) {
        this.connected = conn;
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.plainConnect();
        if (this.cachedResponse != null) {
            return;
        }
    }

    @Override
    protected HttpClient getNewHttpClient(URL url, Proxy p, int connectTimeout) throws IOException {
        return HttpsClient.New(this.lowerNetLayer, url, null, true, connectTimeout);
    }

    @Override
    protected HttpClient getNewHttpClient(URL url, Proxy p, int connectTimeout, boolean useCache) throws IOException {
        return HttpsClient.New(this.lowerNetLayer, url, null, useCache, connectTimeout);
    }

    public String getCipherSuite() {
        if (this.cachedResponse != null) {
            return ((SecureCacheResponse)this.cachedResponse).getCipherSuite();
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getCipherSuite();
    }

    public Certificate[] getLocalCertificates() {
        if (this.cachedResponse != null) {
            List<Certificate> l = ((SecureCacheResponse)this.cachedResponse).getLocalCertificateChain();
            if (l == null) {
                return null;
            }
            return (Certificate[])l.toArray();
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getLocalCertificates();
    }

    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        if (this.cachedResponse != null) {
            List<Certificate> l = ((SecureCacheResponse)this.cachedResponse).getServerCertificateChain();
            if (l == null) {
                return null;
            }
            return (Certificate[])l.toArray();
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getServerCertificates();
    }

    public X509Certificate[] getServerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.cachedResponse != null) {
            throw new UnsupportedOperationException("this method is not supported when using cache");
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getServerCertificateChain();
    }

    Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        if (this.cachedResponse != null) {
            return ((SecureCacheResponse)this.cachedResponse).getPeerPrincipal();
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getPeerPrincipal();
    }

    Principal getLocalPrincipal() {
        if (this.cachedResponse != null) {
            return ((SecureCacheResponse)this.cachedResponse).getLocalPrincipal();
        }
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getLocalPrincipal();
    }
}

