/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.adapter.url.impl.net.https;

import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.HttpClient;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.layer.tls.TLSNetSocket;

final class HttpsClient
extends HttpClient
implements HandshakeCompletedListener {
    private HostnameVerifier hv;
    private SSLSession session;
    protected static final int DEFAULT_HTTPS_PORT = 443;

    @Override
    protected int getDefaultPort() {
        return 443;
    }

    HttpsClient(NetLayer lowerNetLayer, URL url, int connectTimeout) throws IOException {
        super(lowerNetLayer, url, connectTimeout);
        if (this.serverSocket instanceof TLSNetSocket) {
            this.session = ((TLSNetSocket)this.serverSocket).getSSLSession();
        }
    }

    static HttpClient New(NetLayer lowerNetLayer, URL url, HostnameVerifier hv) throws IOException {
        return HttpsClient.New(lowerNetLayer, url, hv, true);
    }

    static HttpClient New(NetLayer lowerNetLayer, URL url, HostnameVerifier hv, boolean useCache) throws IOException {
        return HttpsClient.New(lowerNetLayer, url, hv, useCache, -1);
    }

    static HttpClient New(NetLayer lowerNetLayer, URL url, HostnameVerifier hv, boolean useCache, int connectTimeout) throws IOException {
        HttpsClient ret = null;
        if (useCache && (ret = (HttpsClient)kac.get(url, lowerNetLayer)) != null) {
            ret.cachedHttpClient = true;
        }
        if (ret == null) {
            ret = new HttpsClient(lowerNetLayer, url, connectTimeout);
        } else {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkConnect(url.getHost(), url.getPort());
            }
            ret.url = url;
        }
        ret.setHostnameVerifier(hv);
        return ret;
    }

    void setHostnameVerifier(HostnameVerifier hv) {
        this.hv = hv;
    }

    @Override
    public void closeIdleConnection() {
        HttpClient http = kac.get(this.url, this.lowerNetLayer);
        if (http != null) {
            http.closeServer();
        }
    }

    String getCipherSuite() {
        return this.session.getCipherSuite();
    }

    public Certificate[] getLocalCertificates() {
        return this.session.getLocalCertificates();
    }

    Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        return this.session.getPeerCertificates();
    }

    javax.security.cert.X509Certificate[] getServerCertificateChain() throws SSLPeerUnverifiedException {
        return this.session.getPeerCertificateChain();
    }

    Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        Principal principal;
        try {
            principal = this.session.getPeerPrincipal();
        }
        catch (AbstractMethodError e) {
            Certificate[] certs = this.session.getPeerCertificates();
            principal = ((X509Certificate)certs[0]).getSubjectX500Principal();
        }
        return principal;
    }

    Principal getLocalPrincipal() {
        Principal principal;
        block2: {
            try {
                principal = this.session.getLocalPrincipal();
            }
            catch (AbstractMethodError e) {
                principal = null;
                Certificate[] certs = this.session.getLocalCertificates();
                if (certs == null) break block2;
                principal = ((X509Certificate)certs[0]).getSubjectX500Principal();
            }
        }
        return principal;
    }

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent event) {
        this.session = event.getSession();
    }
}

