/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.adapter.url.impl.net.http;

import java.net.URL;

public class ProgressSource {
    private final URL url;
    private final String method;
    private String contentType;
    private long progress = 0L;
    private long lastProgress = 0L;
    private long expected = -1L;
    private State state;
    private boolean connected = false;
    private int threshold = 8192;

    public ProgressSource(URL url, String method) {
        this(url, method, -1L);
    }

    public ProgressSource(URL url, String method, long expected) {
        this.url = url;
        this.method = method;
        this.contentType = "content/unknown";
        this.progress = 0L;
        this.lastProgress = 0L;
        this.expected = expected;
        this.state = State.NEW;
        this.threshold = 8192;
    }

    public boolean connected() {
        if (!this.connected) {
            this.connected = true;
            this.state = State.CONNECTED;
            return false;
        }
        return true;
    }

    public void close() {
        this.state = State.DELETE;
    }

    public URL getURL() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String ct) {
        this.contentType = ct;
    }

    public long getProgress() {
        return this.progress;
    }

    public long getExpected() {
        return this.expected;
    }

    public State getState() {
        return this.state;
    }

    public void beginTracking() {
    }

    public void finishTracking() {
    }

    public void updateProgress(long latestProgress, long expectedProgress) {
        this.lastProgress = this.progress;
        this.progress = latestProgress;
        this.expected = expectedProgress;
        this.state = !this.connected() ? State.CONNECTED : State.UPDATE;
        if (this.expected != -1L && this.progress >= this.expected && this.progress != 0L) {
            this.close();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return this.getClass().getName() + "[url=" + this.url + ", method=" + this.method + ", state=" + (Object)((Object)this.state) + ", content-type=" + this.contentType + ", progress=" + this.progress + ", expected=" + this.expected + "]";
    }

    public static enum State {
        NEW,
        CONNECTED,
        UPDATE,
        DELETE;

    }
}

