/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.adapter.url.impl.net.http;

import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import javax.xml.bind.DatatypeConverter;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.AuthenticationInfo;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.HeaderParser;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.HttpURLConnection;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.Negotiator;

class NegotiateAuthentication
extends AuthenticationInfo {
    private static final long serialVersionUID = 100L;
    private String scheme = null;
    static final char NEGOTIATE_AUTH = 'S';
    static final char KERBEROS_AUTH = 'K';
    static HashMap<String, Boolean> supported = null;
    static HashMap<String, Negotiator> cache = null;
    private Negotiator negotiator = null;

    public NegotiateAuthentication(boolean isProxy, URL url, PasswordAuthentication pw, String scheme) {
        super(isProxy ? (char)'p' : 's', 'S', url, "");
        this.scheme = scheme;
    }

    public NegotiateAuthentication(boolean isProxy, String host, int port, PasswordAuthentication pw, String scheme) {
        super(isProxy ? (char)'p' : 's', 'S', host, port, "");
        this.scheme = scheme;
    }

    @Override
    boolean supportsPreemptiveAuthorization() {
        return false;
    }

    public static synchronized boolean isSupported(String hostname, String scheme) {
        if (supported == null) {
            supported = new HashMap();
            cache = new HashMap();
        }
        if (supported.containsKey(hostname = hostname.toLowerCase())) {
            return supported.get(hostname);
        }
        try {
            Negotiator neg = Negotiator.getSupported(hostname, scheme);
            supported.put(hostname, true);
            cache.put(hostname, neg);
            return true;
        }
        catch (Exception e) {
            supported.put(hostname, false);
            return false;
        }
    }

    @Override
    String getHeaderName() {
        if (this.type == 's') {
            return "Authorization";
        }
        return "Proxy-Authorization";
    }

    @Override
    String getHeaderValue(URL url, String method) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    @Override
    boolean isAuthorizationStale(String header) {
        return false;
    }

    @Override
    synchronized boolean setHeaders(HttpURLConnection conn, HeaderParser p, String raw) {
        try {
            byte[] incoming = null;
            String[] parts = raw.split("\\s+");
            if (parts.length > 1) {
                incoming = DatatypeConverter.parseBase64Binary((String)parts[1]);
            }
            byte[] token = incoming == null ? this.firstToken() : this.nextToken(incoming);
            String encodedToken = DatatypeConverter.printBase64Binary((byte[])token);
            encodedToken = encodedToken != null ? encodedToken : "INVALID_TOKEN";
            String response = this.scheme + " " + encodedToken;
            conn.setAuthenticationProperty(this.getHeaderName(), response);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] firstToken() throws IOException {
        this.negotiator = null;
        if (cache != null) {
            HashMap<String, Negotiator> hashMap = cache;
            synchronized (hashMap) {
                this.negotiator = cache.get(this.getHost());
                if (this.negotiator != null) {
                    cache.remove(this.getHost());
                }
            }
        }
        if (this.negotiator == null) {
            try {
                this.negotiator = Negotiator.getSupported(this.getHost(), this.scheme);
            }
            catch (Exception e) {
                IOException ioe = new IOException("Cannot initialize Negotiator");
                ioe.initCause(e);
                throw ioe;
            }
        }
        return this.negotiator.firstToken();
    }

    private byte[] nextToken(byte[] token) throws IOException {
        return this.negotiator.nextToken(token);
    }

    @Override
    public void checkResponse(String header, String method, URL url) throws IOException {
    }
}

