/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.adapter.url.impl.net.http;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.HttpClient;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.KeepAliveStream;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.MyKeepAliveCleanerEntry;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.NetProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepAliveStreamCleaner
extends LinkedBlockingQueue<MyKeepAliveCleanerEntry>
implements Runnable {
    private static final Logger LOG;
    protected static int MAX_DATA_REMAINING;
    protected static int MAX_CAPACITY;
    protected static final int TIMEOUT = 5000;
    private static final int MAX_RETRIES = 5;

    public KeepAliveStreamCleaner() {
        super(MAX_CAPACITY);
    }

    public KeepAliveStreamCleaner(int capacity) {
        super(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MyKeepAliveCleanerEntry kace = null;
        do {
            try {
                kace = (MyKeepAliveCleanerEntry)this.poll(5000L, TimeUnit.MILLISECONDS);
                if (kace == null) break;
                KeepAliveStream kas = kace.getKeepAliveStream();
                if (kas == null) continue;
                KeepAliveStream keepAliveStream = kas;
                synchronized (keepAliveStream) {
                    HttpClient hc = kace.getHttpClient();
                    try {
                        if (hc != null && !hc.isInKeepAliveCache()) {
                            int oldTimeout = hc.setTimeout(5000);
                            long remainingToRead = kas.remainingToRead();
                            if (remainingToRead > 0L) {
                                long n = 0L;
                                int retries = 0;
                                while (n < remainingToRead && retries < 5) {
                                    if ((n = kas.skip(remainingToRead -= n)) != 0L) continue;
                                    ++retries;
                                }
                                remainingToRead -= n;
                            }
                            if (remainingToRead == 0L) {
                                hc.setTimeout(oldTimeout);
                                hc.finished();
                            } else {
                                hc.closeServer();
                            }
                        }
                    }
                    catch (IOException ioe) {
                        hc.closeServer();
                        LOG.debug("got IOException : {}", (Object)ioe.getMessage(), (Object)ioe);
                    }
                    finally {
                        kas.setClosed();
                    }
                }
            }
            catch (InterruptedException ie) {
                LOG.debug("got IterruptedException : {}", (Object)ie.getMessage(), (Object)ie);
            }
        } while (kace != null);
    }

    static {
        int maxCapacity;
        int maxData;
        LOG = LoggerFactory.getLogger(KeepAliveStreamCleaner.class);
        MAX_DATA_REMAINING = 512;
        MAX_CAPACITY = 10;
        String maxDataKey = "http.KeepAlive.remainingData";
        MAX_DATA_REMAINING = maxData = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return NetProperties.getInteger("http.KeepAlive.remainingData", MAX_DATA_REMAINING);
            }
        }) * 1024;
        String maxCapacityKey = "http.KeepAlive.queuedConnections";
        MAX_CAPACITY = maxCapacity = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return NetProperties.getInteger("http.KeepAlive.queuedConnections", MAX_CAPACITY);
            }
        }).intValue();
    }
}

