/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.adapter.url.impl.net.http;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.ClientVector;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.HttpClient;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.KeepAliveEntry;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.KeepAliveKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepAliveCache
extends ConcurrentHashMap<KeepAliveKey, ClientVector>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(KeepAliveCache.class);
    private static final long serialVersionUID = -2937172892064557949L;
    static final int MAX_CONNECTIONS = 5;
    static int result = -1;
    static final int LIFETIME = 5000;
    private Thread keepAliveTimer = null;

    static int getMaxConnections() {
        if (result == -1) {
            try {
                result = Integer.parseInt(System.getProperty("http.maxConnections"));
            }
            catch (Exception e) {
                LOG.debug("got Exception : {}", (Object)e.getMessage(), (Object)e);
            }
            if (result <= 0) {
                result = 5;
            }
        }
        return result;
    }

    public synchronized void put(URL url, Object obj, HttpClient http) {
        KeepAliveKey key;
        ClientVector v;
        boolean startThread;
        boolean bl = startThread = this.keepAliveTimer == null;
        if (!startThread && !this.keepAliveTimer.isAlive()) {
            startThread = true;
        }
        if (startThread) {
            this.clear();
            final KeepAliveCache cache = this;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ThreadGroup grp = Thread.currentThread().getThreadGroup();
                    ThreadGroup parent = null;
                    while ((parent = grp.getParent()) != null) {
                        grp = parent;
                    }
                    KeepAliveCache.this.keepAliveTimer = new Thread(grp, cache, "Keep-Alive-Timer");
                    KeepAliveCache.this.keepAliveTimer.setDaemon(true);
                    KeepAliveCache.this.keepAliveTimer.setPriority(8);
                    KeepAliveCache.this.keepAliveTimer.start();
                    return null;
                }
            });
        }
        if ((v = (ClientVector)super.get(key = new KeepAliveKey(url, obj))) == null) {
            int keepAliveTimeout = http.getKeepAliveTimeout();
            v = new ClientVector(keepAliveTimeout > 0 ? keepAliveTimeout * 1000 : 5000);
            v.put(http);
            super.put(key, v);
        } else {
            v.put(http);
        }
    }

    public synchronized void remove(HttpClient h, Object obj) {
        KeepAliveKey key = new KeepAliveKey(h.url, obj);
        ClientVector v = (ClientVector)super.get(key);
        if (v != null) {
            v.remove(h);
            if (v.empty()) {
                this.removeVector(key);
            }
        }
    }

    synchronized void removeVector(KeepAliveKey k) {
        super.remove(k);
    }

    public synchronized HttpClient get(URL url, Object obj) {
        KeepAliveKey key = new KeepAliveKey(url, obj);
        ClientVector v = (ClientVector)super.get(key);
        if (v == null) {
            return null;
        }
        return v.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        do {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOG.debug("got IterruptedException : {}", (Object)e.getMessage(), (Object)e);
            }
            KeepAliveCache keepAliveCache = this;
            synchronized (keepAliveCache) {
                long currentTime = System.currentTimeMillis();
                ArrayList<KeepAliveKey> keysToRemove = new ArrayList<KeepAliveKey>();
                for (KeepAliveKey key : this.keySet()) {
                    ClientVector v;
                    ClientVector clientVector = v = (ClientVector)this.get(key);
                    synchronized (clientVector) {
                        int i;
                        for (i = 0; i < v.size(); ++i) {
                            KeepAliveEntry e = (KeepAliveEntry)v.elementAt(i);
                            if (currentTime - e.idleStartTime <= (long)v.nap) break;
                            HttpClient h = e.hc;
                            h.closeServer();
                        }
                        v.subList(0, i).clear();
                        if (v.size() == 0) {
                            keysToRemove.add(key);
                        }
                    }
                }
                for (KeepAliveKey key : keysToRemove) {
                    this.removeVector(key);
                }
            }
        } while (this.size() > 0);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }
}

