/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.adapter.url.impl.net.http;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.CookieHandler;
import java.net.HttpRetryException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.ResponseCache;
import java.net.SecureCacheResponse;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.AuthenticationHeader;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.AuthenticationInfo;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.BasicAuthentication;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.ChunkedInputStream;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.DigestAuthentication;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.Handler;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.HeaderParser;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.HttpClient;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.MessageHeader;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.MeteredStream;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.NTLMAuthentication;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.NegotiateAuthentication;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.ParseUtil;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.PosterOutputStream;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.ProgressSource;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    private static final Logger LOG = LoggerFactory.getLogger((String)"sun.net.www.protocol.http.HttpURLConnection");
    static String HTTP_CONNECT = "CONNECT";
    static final String version;
    public static final String userAgent;
    static final int defaultmaxRedirects = 20;
    static final int maxRedirects;
    static final boolean validateProxy;
    static final boolean validateServer;
    private StreamingOutputStream strOutputStream;
    private static final String RETRY_MSG1 = "cannot retry due to proxy authentication, in streaming mode";
    private static final String RETRY_MSG2 = "cannot retry due to server authentication, in streaming mode";
    private static final String RETRY_MSG3 = "cannot retry due to redirection, in streaming mode";
    private static boolean enableESBuffer;
    private static int timeout4ESBuffer;
    private static int bufSize4ES;
    static final String httpVersion = "HTTP/1.1";
    static final String acceptString = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    private static final String[] EXCLUDE_HEADERS;
    protected HttpClient http;
    protected Handler handler;
    protected Proxy instProxy;
    private CookieHandler cookieHandler;
    private ResponseCache cacheHandler;
    protected CacheResponse cachedResponse;
    private MessageHeader cachedHeaders;
    private InputStream cachedInputStream;
    protected PrintStream ps = null;
    private InputStream errorStream = null;
    private boolean setUserCookies = true;
    private String userCookies = null;
    private MessageHeader requests;
    String domain;
    DigestAuthentication.Parameters digestparams;
    AuthenticationInfo currentProxyCredentials = null;
    AuthenticationInfo currentServerCredentials = null;
    boolean needToCheck = true;
    private boolean doingNTLM2ndStage = false;
    private boolean doingNTLMp2ndStage = false;
    private final boolean tryTransparentNTLMServer = NTLMAuthentication.supportsTransparentAuth();
    private final boolean tryTransparentNTLMProxy = NTLMAuthentication.supportsTransparentAuth();
    Object authObj;
    boolean isUserServerAuth;
    boolean isUserProxyAuth;
    protected ProgressSource pi;
    private MessageHeader responses;
    private InputStream inputStream = null;
    private PosterOutputStream poster = null;
    private boolean setRequests = false;
    private boolean failedOnce = false;
    private Exception rememberedException = null;
    private HttpClient reuseClient = null;
    private TunnelState tunnelState = TunnelState.NONE;
    private int connectTimeout = -1;
    private int readTimeout = -1;
    protected long fixedContentLengthLong = -1L;
    protected NetLayer lowerNetLayer;
    byte[] cdata = new byte[128];

    private static PasswordAuthentication privilegedRequestPasswordAuthentication(final String host, final InetAddress addr, final int port, final String protocol, final String prompt, final String scheme, final URL url, final Authenticator.RequestorType authType) {
        return AccessController.doPrivileged(new PrivilegedAction<PasswordAuthentication>(){

            @Override
            public PasswordAuthentication run() {
                return Authenticator.requestPasswordAuthentication(host, addr, port, protocol, prompt, scheme, url, authType);
            }
        });
    }

    private void checkMessageHeader(String key, String value) {
        int LF = 10;
        int index = key.indexOf(10);
        if (index != -1) {
            throw new IllegalArgumentException("Illegal character(s) in message header field: " + key);
        }
        if (value == null) {
            return;
        }
        index = value.indexOf(10);
        while (index != -1) {
            char c;
            if (++index < value.length() && ((c = value.charAt(index)) == ' ' || c == '\t')) {
                index = value.indexOf(10, index);
                continue;
            }
            throw new IllegalArgumentException("Illegal character(s) in message header value: " + value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequests() throws IOException {
        if (!this.setRequests) {
            AuthenticationInfo sauth;
            if (!this.failedOnce) {
                this.requests.prepend(this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            }
            if (!this.getUseCaches()) {
                this.requests.setIfNotSet("Cache-Control", "no-cache");
                this.requests.setIfNotSet("Pragma", "no-cache");
            }
            this.requests.setIfNotSet("User-Agent", userAgent);
            int port = this.url.getPort();
            String host = this.url.getHost();
            if (port != -1 && port != this.url.getDefaultPort()) {
                host = host + ":" + String.valueOf(port);
            }
            this.requests.setIfNotSet("Host", host);
            this.requests.setIfNotSet("Accept", acceptString);
            if (!this.failedOnce && this.http.getHttpKeepAliveSet()) {
                this.requests.setIfNotSet("Connection", "keep-alive");
            } else {
                this.requests.setIfNotSet("Connection", "close");
            }
            long modTime = this.getIfModifiedSince();
            if (modTime != 0L) {
                Date date = new Date(modTime);
                SimpleDateFormat fo = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
                fo.setTimeZone(TimeZone.getTimeZone("GMT"));
                this.requests.setIfNotSet("If-Modified-Since", fo.format(date));
            }
            if ((sauth = AuthenticationInfo.getServerAuth(this.url)) != null && sauth.supportsPreemptiveAuthorization()) {
                this.requests.setIfNotSet(sauth.getHeaderName(), sauth.getHeaderValue(this.url, this.method));
                this.currentServerCredentials = sauth;
            }
            if (!this.method.equals("PUT") && (this.poster != null || this.streaming())) {
                this.requests.setIfNotSet("Content-type", "application/x-www-form-urlencoded");
            }
            if (this.streaming()) {
                if (this.chunkLength != -1) {
                    this.requests.set("Transfer-Encoding", "chunked");
                } else if (this.fixedContentLengthLong != -1L) {
                    this.requests.set("Content-Length", String.valueOf(this.fixedContentLengthLong));
                } else if (this.fixedContentLength != -1) {
                    this.requests.set("Content-Length", String.valueOf(this.fixedContentLength));
                }
            } else if (this.poster != null) {
                PosterOutputStream posterOutputStream = this.poster;
                synchronized (posterOutputStream) {
                    this.poster.close();
                    this.requests.set("Content-Length", String.valueOf(this.poster.size()));
                }
            }
            this.setCookieHeader();
            this.setRequests = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.requests.toString());
        }
        this.http.writeRequests(this.requests, this.poster);
        if (this.ps.checkError()) {
            String proxyHost = this.http.getProxyHostUsed();
            int proxyPort = this.http.getProxyPortUsed();
            this.disconnectInternal();
            if (this.failedOnce) {
                throw new IOException("Error writing to server");
            }
            this.failedOnce = true;
            if (proxyHost != null) {
                this.setProxiedClient(this.url, proxyHost, proxyPort);
            } else {
                this.setNewClient(this.url);
            }
            this.ps = (PrintStream)this.http.getOutputStream();
            this.connected = true;
            this.responses = new MessageHeader();
            this.setRequests = false;
            this.writeRequests();
        }
    }

    protected void setNewClient(URL url) throws IOException {
        this.setNewClient(url, false);
    }

    protected void setNewClient(URL url, boolean useCache) throws IOException {
        this.http = HttpClient.New(this.lowerNetLayer, url, useCache);
        this.http.setReadTimeout(this.readTimeout);
    }

    protected void setProxiedClient(URL url, String proxyHost, int proxyPort) throws IOException {
        this.setProxiedClient(url, proxyHost, proxyPort, false);
    }

    protected void setProxiedClient(URL url, String proxyHost, int proxyPort, boolean useCache) throws IOException {
        this.proxiedConnect(url, proxyHost, proxyPort, useCache);
    }

    protected void proxiedConnect(URL url, String proxyHost, int proxyPort, boolean useCache) throws IOException {
        this.http = HttpClient.New(this.lowerNetLayer, url, useCache);
        this.http.setReadTimeout(this.readTimeout);
    }

    protected HttpURLConnection(NetLayer lowerNetLayer, URL u, Handler handler) throws IOException {
        this(lowerNetLayer, u, null, handler);
    }

    public HttpURLConnection(NetLayer lowerNetLayer, URL u, String host, int port) {
        this(lowerNetLayer, u, new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(host, port)));
    }

    public HttpURLConnection(NetLayer lowerNetLayer, URL u, Proxy p) {
        this(lowerNetLayer, u, p, new Handler());
    }

    protected HttpURLConnection(NetLayer lowerNetLayer, URL u, Proxy p, Handler handler) {
        super(u);
        this.lowerNetLayer = lowerNetLayer;
        this.requests = new MessageHeader();
        this.responses = new MessageHeader();
        this.handler = handler;
        this.instProxy = p;
    }

    public static InputStream openConnectionCheckRedirects(URLConnection c) throws IOException {
        boolean redir;
        int redirects = 0;
        InputStream in = null;
        do {
            HttpURLConnection http;
            int stat;
            if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).setInstanceFollowRedirects(false);
            }
            in = c.getInputStream();
            redir = false;
            if (!(c instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)c).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || !base.getProtocol().equals(target.getProtocol()) || base.getPort() != target.getPort() || !HttpURLConnection.hostsEqual(base, target) || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            c = target.openConnection();
            ++redirects;
        } while (redir);
        return in;
    }

    private static boolean hostsEqual(URL u1, URL u2) {
        final String h1 = u1.getHost();
        final String h2 = u2.getHost();
        if (h1 == null) {
            return h2 == null;
        }
        if (h2 == null) {
            return false;
        }
        if (h1.equalsIgnoreCase(h2)) {
            return true;
        }
        final boolean[] result = new boolean[]{false};
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    InetAddress a1 = InetAddress.getByName(h1);
                    InetAddress a2 = InetAddress.getByName(h2);
                    result[0] = a1.equals(a2);
                }
                catch (UnknownHostException e) {
                    LOG.debug("got UnknownHostException : {}", (Object)e.getMessage(), (Object)e);
                }
                catch (SecurityException e) {
                    LOG.debug("got SecurityException : {}", (Object)e.getMessage(), (Object)e);
                }
                return null;
            }
        });
        return result[0];
    }

    @Override
    public void connect() throws IOException {
        this.plainConnect();
    }

    private boolean checkReuseConnection() {
        if (this.connected) {
            return true;
        }
        if (this.reuseClient != null) {
            this.http = this.reuseClient;
            this.http.setReadTimeout(this.getReadTimeout());
            this.http.reuse = false;
            this.reuseClient = null;
            this.connected = true;
            return true;
        }
        return false;
    }

    protected void plainConnect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.cacheHandler != null && this.getUseCaches()) {
            try {
                URI uri = ParseUtil.toURI(this.url);
                if (uri != null) {
                    this.cachedResponse = this.cacheHandler.get(uri, this.getRequestMethod(), this.requests.getHeaders(EXCLUDE_HEADERS));
                    if ("https".equalsIgnoreCase(uri.getScheme()) && !(this.cachedResponse instanceof SecureCacheResponse)) {
                        this.cachedResponse = null;
                    }
                    if (this.cachedResponse != null) {
                        this.cachedHeaders = this.mapToMessageHeader(this.cachedResponse.getHeaders());
                        this.cachedInputStream = this.cachedResponse.getBody();
                    }
                }
            }
            catch (IOException ioex) {
                LOG.debug("got IOException : {}", (Object)ioex.getMessage(), (Object)ioex);
            }
            if (this.cachedHeaders != null && this.cachedInputStream != null) {
                this.connected = true;
                return;
            }
            this.cachedResponse = null;
        }
        if (this.instProxy == null) {
            ProxySelector sel = AccessController.doPrivileged(new PrivilegedAction<ProxySelector>(){

                @Override
                public ProxySelector run() {
                    return ProxySelector.getDefault();
                }
            });
            Proxy p = null;
            if (sel != null) {
                URI uri = ParseUtil.toURI(this.url);
                Iterator<Proxy> it = sel.select(uri).iterator();
                while (it.hasNext()) {
                    p = it.next();
                    try {
                        if (!this.failedOnce) {
                            this.http = this.getNewHttpClient(this.url, p, this.connectTimeout);
                            this.http.setReadTimeout(this.readTimeout);
                        } else {
                            this.http = this.getNewHttpClient(this.url, p, this.connectTimeout, false);
                            this.http.setReadTimeout(this.readTimeout);
                        }
                        break;
                    }
                    catch (IOException ioex) {
                        if (p != Proxy.NO_PROXY) {
                            sel.connectFailed(uri, p.address(), ioex);
                            if (it.hasNext()) continue;
                            this.http = this.getNewHttpClient(this.url, null, this.connectTimeout, false);
                            this.http.setReadTimeout(this.readTimeout);
                            break;
                        }
                        throw ioex;
                    }
                }
            } else if (!this.failedOnce) {
                this.http = this.getNewHttpClient(this.url, null, this.connectTimeout);
                this.http.setReadTimeout(this.readTimeout);
            } else {
                this.http = this.getNewHttpClient(this.url, null, this.connectTimeout, false);
                this.http.setReadTimeout(this.readTimeout);
            }
        } else if (!this.failedOnce) {
            this.http = this.getNewHttpClient(this.url, this.instProxy, this.connectTimeout);
            this.http.setReadTimeout(this.readTimeout);
        } else {
            this.http = this.getNewHttpClient(this.url, this.instProxy, this.connectTimeout, false);
            this.http.setReadTimeout(this.readTimeout);
        }
        this.ps = (PrintStream)this.http.getOutputStream();
        this.connected = true;
    }

    protected HttpClient getNewHttpClient(URL url, Proxy p, int connectTimeout) throws IOException {
        return HttpClient.New(this.lowerNetLayer, url, connectTimeout, true);
    }

    protected HttpClient getNewHttpClient(URL url, Proxy p, int connectTimeout, boolean useCache) throws IOException {
        return HttpClient.New(this.lowerNetLayer, url, connectTimeout, useCache);
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            if (!this.doOutput) {
                throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
            }
            if (this.method.equals("GET")) {
                this.method = "POST";
            }
            if (!"POST".equals(this.method) && !"PUT".equals(this.method) && "http".equals(this.url.getProtocol())) {
                throw new ProtocolException("HTTP method " + this.method + " doesn't support output");
            }
            if (this.inputStream != null) {
                throw new ProtocolException("Cannot write output after reading input.");
            }
            if (!this.checkReuseConnection()) {
                this.connect();
            }
            if (this.streaming() && this.strOutputStream == null) {
                this.writeRequests();
            }
            this.ps = (PrintStream)this.http.getOutputStream();
            if (this.streaming()) {
                if (this.strOutputStream == null) {
                    if (this.chunkLength != -1) {
                        this.strOutputStream = new StreamingOutputStream(this.ps, -1L);
                    } else {
                        long length = 0L;
                        if (this.fixedContentLengthLong != -1L) {
                            length = this.fixedContentLengthLong;
                        } else if (this.fixedContentLength != -1) {
                            length = this.fixedContentLength;
                        }
                        this.strOutputStream = new StreamingOutputStream(this.ps, length);
                    }
                }
                return this.strOutputStream;
            }
            if (this.poster == null) {
                this.poster = new PosterOutputStream();
            }
            return this.poster;
        }
        catch (RuntimeException e) {
            this.disconnectInternal();
            throw e;
        }
        catch (IOException e) {
            this.disconnectInternal();
            throw e;
        }
    }

    private boolean streaming() {
        return this.fixedContentLength != -1 || this.fixedContentLengthLong != -1L || this.chunkLength != -1;
    }

    private void setCookieHeader() throws IOException {
        if (this.cookieHandler != null) {
            Map<String, List<String>> cookies;
            if (this.setUserCookies) {
                int k = this.requests.getKeyPos("Cookie");
                if (k != -1) {
                    this.userCookies = this.requests.getValue(k);
                }
                this.setUserCookies = false;
            }
            this.requests.remove("Cookie");
            URI uri = ParseUtil.toURI(this.url);
            if (uri != null && !(cookies = this.cookieHandler.get(uri, this.requests.getHeaders(EXCLUDE_HEADERS))).isEmpty()) {
                for (Map.Entry<String, List<String>> entry : cookies.entrySet()) {
                    List<String> l;
                    String key = entry.getKey();
                    if (!"Cookie".equalsIgnoreCase(key) && !"Cookie2".equalsIgnoreCase(key) || (l = entry.getValue()) == null || l.isEmpty()) continue;
                    StringBuilder cookieValue = new StringBuilder();
                    for (String value : l) {
                        cookieValue.append(value).append("; ");
                    }
                    try {
                        this.requests.add(key, cookieValue.substring(0, cookieValue.length() - 2));
                    }
                    catch (StringIndexOutOfBoundsException ignored) {
                        LOG.debug("got StringIndexOutOfBoundsException : {}", (Object)ignored.getMessage());
                    }
                }
            }
            if (this.userCookies != null) {
                int k = this.requests.getKeyPos("Cookie");
                if (k != -1) {
                    this.requests.set("Cookie", this.requests.getValue(k) + ";" + this.userCookies);
                } else {
                    this.requests.set("Cookie", this.userCookies);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized InputStream getInputStream() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[DOLOOP]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IOException getChainedException(final IOException rememberedException) {
        try {
            final Object[] args = new Object[]{rememberedException.getMessage()};
            IOException chainedException = AccessController.doPrivileged(new PrivilegedExceptionAction<IOException>(){

                @Override
                public IOException run() throws Exception {
                    return (IOException)rememberedException.getClass().getConstructor(String.class).newInstance(args);
                }
            });
            chainedException.initCause(rememberedException);
            return chainedException;
        }
        catch (Exception ignored) {
            return rememberedException;
        }
    }

    @Override
    public InputStream getErrorStream() {
        if (this.connected && this.responseCode >= 400) {
            if (this.errorStream != null) {
                return this.errorStream;
            }
            if (this.inputStream != null) {
                return this.inputStream;
            }
        }
        return null;
    }

    private AuthenticationInfo resetProxyAuthentication(AuthenticationInfo proxyAuthentication, AuthenticationHeader auth) {
        if (proxyAuthentication != null && !(proxyAuthentication instanceof NTLMAuthentication)) {
            String raw = auth.raw();
            if (proxyAuthentication.isAuthorizationStale(raw)) {
                String value = this.tunnelState() == TunnelState.SETUP && proxyAuthentication instanceof DigestAuthentication ? ((DigestAuthentication)proxyAuthentication).getHeaderValue(HttpURLConnection.connectRequestURI(this.url), HTTP_CONNECT) : proxyAuthentication.getHeaderValue(this.url, this.method);
                this.requests.set(proxyAuthentication.getHeaderName(), value);
                this.currentProxyCredentials = proxyAuthentication;
                return proxyAuthentication;
            }
            proxyAuthentication.removeFromCache();
        }
        this.currentProxyCredentials = proxyAuthentication = this.getHttpProxyAuthentication(auth);
        return proxyAuthentication;
    }

    TunnelState tunnelState() {
        return this.tunnelState;
    }

    void setTunnelState(TunnelState tunnelState) {
        this.tunnelState = tunnelState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doTunneling() throws IOException {
        int retryTunnel = 0;
        String statusLine = "";
        int respCode = 0;
        AuthenticationInfo proxyAuthentication = null;
        String proxyHost = null;
        int proxyPort = -1;
        MessageHeader savedRequests = this.requests;
        this.requests = new MessageHeader();
        boolean inNegotiateProxy = false;
        try {
            this.setTunnelState(TunnelState.SETUP);
            do {
                if (!this.checkReuseConnection()) {
                    this.proxiedConnect(this.url, proxyHost, proxyPort, false);
                }
                this.sendCONNECTRequest();
                this.responses.reset();
                this.http.parseHTTP(this.responses, null, this);
                LOG.debug(this.responses.toString());
                statusLine = this.responses.getValue(0);
                StringTokenizer st = new StringTokenizer(statusLine);
                st.nextToken();
                respCode = Integer.parseInt(st.nextToken().trim());
                if (respCode == 407) {
                    boolean dontUseNegotiate = false;
                    Iterator<String> iter = this.responses.multiValueIterator("Proxy-Authenticate");
                    while (iter.hasNext()) {
                        String value = iter.next().trim();
                        if (!value.equalsIgnoreCase("Negotiate") && !value.equalsIgnoreCase("Kerberos")) continue;
                        if (!inNegotiateProxy) {
                            inNegotiateProxy = true;
                            break;
                        }
                        dontUseNegotiate = true;
                        this.doingNTLMp2ndStage = false;
                        proxyAuthentication = null;
                        break;
                    }
                    AuthenticationHeader authhdr = new AuthenticationHeader("Proxy-Authenticate", this.responses, this.http.getProxyHostUsed());
                    if (!this.doingNTLMp2ndStage) {
                        if ((proxyAuthentication = this.resetProxyAuthentication(proxyAuthentication, authhdr)) != null) {
                            proxyHost = this.http.getProxyHostUsed();
                            proxyPort = this.http.getProxyPortUsed();
                            this.disconnectInternal();
                            ++retryTunnel;
                            continue;
                        }
                    } else {
                        String raw = this.responses.findValue("Proxy-Authenticate");
                        this.reset();
                        if (!proxyAuthentication.setHeaders(this, authhdr.headerParser(), raw)) {
                            proxyHost = this.http.getProxyHostUsed();
                            proxyPort = this.http.getProxyPortUsed();
                            this.disconnectInternal();
                            throw new IOException("Authentication failure");
                        }
                        this.authObj = null;
                        this.doingNTLMp2ndStage = false;
                        continue;
                    }
                }
                if (proxyAuthentication != null) {
                    proxyAuthentication.addToCache();
                }
                if (respCode == 200) {
                    this.setTunnelState(TunnelState.TUNNELING);
                    break;
                }
                this.disconnectInternal();
                this.setTunnelState(TunnelState.NONE);
                break;
            } while (retryTunnel < maxRedirects);
            if (retryTunnel >= maxRedirects || respCode != 200) {
                throw new IOException("Unable to tunnel through proxy. Proxy returns \"" + statusLine + "\"");
            }
        }
        finally {
            if (respCode == 407 && proxyAuthentication != null) {
                proxyAuthentication.endAuthRequest();
            }
        }
        this.requests = savedRequests;
        this.responses.reset();
    }

    static String connectRequestURI(URL url) {
        String host = url.getHost();
        int port = url.getPort();
        port = port != -1 ? port : url.getDefaultPort();
        return host + ":" + port;
    }

    private void sendCONNECTRequest() throws IOException {
        int port = this.url.getPort();
        if (this.setRequests) {
            this.requests.set(0, null, null);
        }
        this.requests.prepend(HTTP_CONNECT + " " + HttpURLConnection.connectRequestURI(this.url) + " " + httpVersion, null);
        this.requests.setIfNotSet("User-Agent", userAgent);
        String host = this.url.getHost();
        if (port != -1 && port != this.url.getDefaultPort()) {
            host = host + ":" + String.valueOf(port);
        }
        this.requests.setIfNotSet("Host", host);
        this.requests.setIfNotSet("Accept", acceptString);
        this.setPreemptiveProxyAuthentication(this.requests);
        LOG.debug(this.requests.toString());
        this.http.writeRequests(this.requests, null);
        this.requests.set(0, null, null);
    }

    private void setPreemptiveProxyAuthentication(MessageHeader requests) {
        AuthenticationInfo pauth = AuthenticationInfo.getProxyAuth(this.http.getProxyHostUsed(), this.http.getProxyPortUsed());
        if (pauth != null && pauth.supportsPreemptiveAuthorization()) {
            String value = this.tunnelState() == TunnelState.SETUP && pauth instanceof DigestAuthentication ? ((DigestAuthentication)pauth).getHeaderValue(HttpURLConnection.connectRequestURI(this.url), HTTP_CONNECT) : pauth.getHeaderValue(this.url, this.method);
            requests.set(pauth.getHeaderName(), value);
            this.currentProxyCredentials = pauth;
        }
    }

    private AuthenticationInfo getHttpProxyAuthentication(AuthenticationHeader authhdr) {
        AuthenticationInfo ret = null;
        String raw = authhdr.raw();
        String host = this.http.getProxyHostUsed();
        int port = this.http.getProxyPortUsed();
        if (host != null && authhdr.isPresent()) {
            int schemeID;
            HeaderParser p = authhdr.headerParser();
            String realm = p.findValue("realm");
            String scheme = authhdr.scheme();
            if ("basic".equalsIgnoreCase(scheme)) {
                schemeID = 66;
            } else if ("digest".equalsIgnoreCase(scheme)) {
                schemeID = 68;
            } else if ("Kerberos".equalsIgnoreCase(scheme)) {
                schemeID = 75;
                this.doingNTLMp2ndStage = true;
            } else if ("Negotiate".equalsIgnoreCase(scheme)) {
                schemeID = 83;
                this.doingNTLMp2ndStage = true;
            } else {
                schemeID = 0;
            }
            if (realm == null) {
                realm = "";
            }
            if ((ret = AuthenticationInfo.getProxyAuth(host, port, realm, (char)schemeID)) == null) {
                if (schemeID == 66) {
                    InetAddress addr = null;
                    try {
                        final String finalHost = host;
                        addr = AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress>(){

                            @Override
                            public InetAddress run() throws UnknownHostException {
                                return InetAddress.getByName(finalHost);
                            }
                        });
                    }
                    catch (PrivilegedActionException ignored) {
                        LOG.debug("got PrivilegedActionException : {}", (Object)ignored.getMessage(), (Object)ignored);
                    }
                    PasswordAuthentication a = HttpURLConnection.privilegedRequestPasswordAuthentication(host, addr, port, "http", realm, scheme, this.url, Authenticator.RequestorType.PROXY);
                    if (a != null) {
                        ret = new BasicAuthentication(true, host, port, realm, a);
                    }
                } else if (schemeID == 68) {
                    PasswordAuthentication a = HttpURLConnection.privilegedRequestPasswordAuthentication(host, null, port, this.url.getProtocol(), realm, scheme, this.url, Authenticator.RequestorType.PROXY);
                    if (a != null) {
                        DigestAuthentication.Parameters params = new DigestAuthentication.Parameters();
                        ret = new DigestAuthentication(true, host, port, realm, scheme, a, params);
                    }
                } else if (schemeID == 83) {
                    ret = new NegotiateAuthentication(true, host, port, null, "Negotiate");
                } else if (schemeID == 75) {
                    ret = new NegotiateAuthentication(true, host, port, null, "Kerberos");
                }
            }
            if (ret != null && !ret.setHeaders(this, p, raw)) {
                ret = null;
            }
        }
        return ret;
    }

    private AuthenticationInfo getServerAuthentication(AuthenticationHeader authhdr) {
        AuthenticationInfo ret = null;
        String raw = authhdr.raw();
        if (authhdr.isPresent()) {
            int port;
            char schemeID;
            HeaderParser p = authhdr.headerParser();
            String realm = p.findValue("realm");
            String scheme = authhdr.scheme();
            if ("basic".equalsIgnoreCase(scheme)) {
                schemeID = 'B';
            } else if ("digest".equalsIgnoreCase(scheme)) {
                schemeID = 'D';
            } else if ("Kerberos".equalsIgnoreCase(scheme)) {
                schemeID = 'K';
                this.doingNTLM2ndStage = true;
            } else if ("Negotiate".equalsIgnoreCase(scheme)) {
                schemeID = 'S';
                this.doingNTLM2ndStage = true;
            } else {
                schemeID = '\u0000';
            }
            this.domain = p.findValue("domain");
            if (realm == null) {
                realm = "";
            }
            ret = AuthenticationInfo.getServerAuth(this.url, realm, schemeID);
            InetAddress addr = null;
            if (ret == null) {
                try {
                    addr = InetAddress.getByName(this.url.getHost());
                }
                catch (UnknownHostException ignored) {
                    LOG.debug("got UnknownHostException : {}", (Object)ignored.getMessage(), (Object)ignored);
                }
            }
            if ((port = this.url.getPort()) == -1) {
                port = this.url.getDefaultPort();
            }
            if (ret == null) {
                PasswordAuthentication a;
                URL url1;
                if (schemeID == 'K') {
                    try {
                        url1 = new URL(this.url, "/");
                    }
                    catch (Exception e) {
                        url1 = this.url;
                    }
                    ret = new NegotiateAuthentication(false, url1, null, "Kerberos");
                }
                if (schemeID == 'S') {
                    try {
                        url1 = new URL(this.url, "/");
                    }
                    catch (Exception e) {
                        url1 = this.url;
                    }
                    ret = new NegotiateAuthentication(false, url1, null, "Negotiate");
                }
                if (schemeID == 'B' && (a = HttpURLConnection.privilegedRequestPasswordAuthentication(this.url.getHost(), addr, port, this.url.getProtocol(), realm, scheme, this.url, Authenticator.RequestorType.SERVER)) != null) {
                    ret = new BasicAuthentication(false, this.url, realm, a);
                }
                if (schemeID == 'D' && (a = HttpURLConnection.privilegedRequestPasswordAuthentication(this.url.getHost(), addr, port, this.url.getProtocol(), realm, scheme, this.url, Authenticator.RequestorType.SERVER)) != null) {
                    this.digestparams = new DigestAuthentication.Parameters();
                    ret = new DigestAuthentication(false, this.url, realm, scheme, a, this.digestparams);
                }
            }
            if (ret != null && !ret.setHeaders(this, p, raw)) {
                ret = null;
            }
        }
        return ret;
    }

    private void checkResponseCredentials(boolean inClose) throws IOException {
        try {
            String raw;
            if (!this.needToCheck) {
                return;
            }
            if (validateProxy && this.currentProxyCredentials != null) {
                raw = this.responses.findValue("Proxy-Authentication-Info");
                if (inClose || raw != null) {
                    this.currentProxyCredentials.checkResponse(raw, this.method, this.url);
                    this.currentProxyCredentials = null;
                }
            }
            if (validateServer && this.currentServerCredentials != null) {
                raw = this.responses.findValue("Authentication-Info");
                if (inClose || raw != null) {
                    this.currentServerCredentials.checkResponse(raw, this.method, this.url);
                    this.currentServerCredentials = null;
                }
            }
            if (this.currentServerCredentials == null && this.currentProxyCredentials == null) {
                this.needToCheck = false;
            }
        }
        catch (IOException e) {
            this.disconnectInternal();
            this.connected = false;
            throw e;
        }
    }

    private boolean followRedirect() throws IOException {
        URL locUrl;
        if (!this.getInstanceFollowRedirects()) {
            return false;
        }
        int stat = this.getResponseCode();
        if (stat < 300 || stat > 307 || stat == 306 || stat == 304) {
            return false;
        }
        String loc = this.getHeaderField("Location");
        if (loc == null) {
            return false;
        }
        try {
            locUrl = new URL(loc);
            if (!this.url.getProtocol().equalsIgnoreCase(locUrl.getProtocol())) {
                return false;
            }
        }
        catch (MalformedURLException mue) {
            locUrl = new URL(this.url, loc);
        }
        this.disconnectInternal();
        if (this.streaming()) {
            throw new HttpRetryException(RETRY_MSG3, stat, loc);
        }
        this.responses = new MessageHeader();
        if (stat == 305) {
            String proxyHost = locUrl.getHost();
            int proxyPort = locUrl.getPort();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkConnect(proxyHost, proxyPort);
            }
            this.setProxiedClient(this.url, proxyHost, proxyPort);
            this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            this.connected = true;
        } else {
            this.url = locUrl;
            if (this.method.equals("POST") && !Boolean.getBoolean("http.strictPostRedirect") && stat != 307) {
                this.requests = new MessageHeader();
                this.setRequests = false;
                this.setRequestMethod("GET");
                this.poster = null;
                if (!this.checkReuseConnection()) {
                    this.connect();
                }
            } else {
                if (!this.checkReuseConnection()) {
                    this.connect();
                }
                if (this.http != null) {
                    this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
                    int port = this.url.getPort();
                    String host = this.url.getHost();
                    if (port != -1 && port != this.url.getDefaultPort()) {
                        host = host + ":" + String.valueOf(port);
                    }
                    this.requests.set("Host", host);
                }
            }
        }
        return true;
    }

    private void reset() throws IOException {
        this.http.reuse = true;
        this.reuseClient = this.http;
        InputStream is = this.http.getInputStream();
        if (!this.method.equals("HEAD")) {
            block11: {
                try {
                    if (is instanceof ChunkedInputStream || is instanceof MeteredStream) {
                        while (is.read(this.cdata) > 0) {
                        }
                        break block11;
                    }
                    int cl = 0;
                    int n = 0;
                    try {
                        cl = Integer.parseInt(this.responses.findValue("Content-Length"));
                    }
                    catch (Exception e) {
                        LOG.debug("got Exception while parsing content-length : {}", (Object)e, (Object)e);
                    }
                    for (int i = 0; i < cl && (n = is.read(this.cdata)) != -1; i += n) {
                    }
                }
                catch (IOException e) {
                    this.http.reuse = false;
                    this.reuseClient = null;
                    this.disconnectInternal();
                    return;
                }
            }
            try {
                if (is instanceof MeteredStream) {
                    is.close();
                }
            }
            catch (IOException e) {
                LOG.debug("got IOException : {}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.responseCode = -1;
        this.responses = new MessageHeader();
        this.connected = false;
    }

    private void disconnectInternal() {
        this.responseCode = -1;
        this.inputStream = null;
        if (this.pi != null) {
            this.pi.finishTracking();
            this.pi = null;
        }
        if (this.http != null) {
            this.http.closeServer();
            this.http = null;
            this.connected = false;
        }
    }

    @Override
    public void disconnect() {
        this.responseCode = -1;
        if (this.pi != null) {
            this.pi.finishTracking();
            this.pi = null;
        }
        if (this.http != null) {
            if (this.inputStream != null) {
                HttpClient hc = this.http;
                boolean ka = hc.isKeepingAlive();
                try {
                    this.inputStream.close();
                }
                catch (IOException ioe) {
                    LOG.debug("got IOException : {}", (Object)ioe.getMessage(), (Object)ioe);
                }
                if (ka) {
                    hc.closeIdleConnection();
                }
            } else {
                this.http.setDoNotRetry(true);
                this.http.closeServer();
            }
            this.http = null;
            this.connected = false;
        }
        this.cachedInputStream = null;
        if (this.cachedHeaders != null) {
            this.cachedHeaders.reset();
        }
    }

    @Override
    public boolean usingProxy() {
        if (this.http != null) {
            return this.http.getProxyHostUsed() != null;
        }
        return false;
    }

    @Override
    public String getHeaderField(String name) {
        try {
            this.getInputStream();
        }
        catch (IOException e) {
            LOG.debug("got IOException : {}", (Object)e.getMessage(), (Object)e);
        }
        if (this.cachedHeaders != null) {
            return this.cachedHeaders.findValue(name);
        }
        return this.responses.findValue(name);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        try {
            this.getInputStream();
        }
        catch (IOException e) {
            LOG.debug("got IOException : {}", (Object)e.getMessage(), (Object)e);
        }
        if (this.cachedHeaders != null) {
            return this.cachedHeaders.getHeaders();
        }
        return this.responses.getHeaders();
    }

    @Override
    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException e) {
            LOG.debug("got IOException : {}", (Object)e.getMessage(), (Object)e);
        }
        if (this.cachedHeaders != null) {
            return this.cachedHeaders.getValue(n);
        }
        return this.responses.getValue(n);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException e) {
            LOG.debug("got IOException : {}", (Object)e.getMessage(), (Object)e);
        }
        if (this.cachedHeaders != null) {
            return this.cachedHeaders.getKey(n);
        }
        return this.responses.getKey(n);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        this.checkMessageHeader(key, value);
        this.requests.set(key, value);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        this.checkMessageHeader(key, value);
        this.requests.add(key, value);
    }

    void setAuthenticationProperty(String key, String value) {
        this.checkMessageHeader(key, value);
        this.requests.set(key, value);
    }

    @Override
    public String getRequestProperty(String key) {
        if (key != null) {
            for (int i = 0; i < EXCLUDE_HEADERS.length; ++i) {
                if (!key.equalsIgnoreCase(EXCLUDE_HEADERS[i])) continue;
                return null;
            }
        }
        return this.requests.findValue(key);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return this.requests.getHeaders(EXCLUDE_HEADERS);
    }

    @Override
    public void setConnectTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeouts can't be negative");
        }
        this.connectTimeout = timeout;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout < 0 ? 0 : this.connectTimeout;
    }

    @Override
    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeouts can't be negative");
        }
        this.readTimeout = timeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout < 0 ? 0 : this.readTimeout;
    }

    protected void finalize() {
    }

    String getMethod() {
        return this.method;
    }

    private MessageHeader mapToMessageHeader(Map<String, List<String>> map) {
        MessageHeader headers = new MessageHeader();
        if (map == null || map.isEmpty()) {
            return headers;
        }
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            for (String value : values) {
                if (key == null) {
                    headers.prepend(key, value);
                    continue;
                }
                headers.add(key, value);
            }
        }
        return headers;
    }

    static {
        enableESBuffer = false;
        timeout4ESBuffer = 0;
        bufSize4ES = 0;
        version = "";
        userAgent = "";
        maxRedirects = 3;
        validateProxy = false;
        validateServer = false;
        EXCLUDE_HEADERS = new String[]{"Proxy-Authorization", "Authorization"};
    }

    static class ErrorStream
    extends InputStream {
        ByteBuffer buffer;
        InputStream is;

        private ErrorStream(ByteBuffer buf) {
            this.buffer = buf;
            this.is = null;
        }

        private ErrorStream(ByteBuffer buf, InputStream is) {
            this.buffer = buf;
            this.is = is;
        }

        public static InputStream getErrorStream(InputStream is, long cl, HttpClient http) {
            if (cl == 0L) {
                return null;
            }
            try {
                int oldTimeout = http.setTimeout(timeout4ESBuffer / 5);
                long expected = 0L;
                boolean isChunked = false;
                if (cl < 0L) {
                    expected = bufSize4ES;
                    isChunked = true;
                } else {
                    expected = cl;
                }
                if (expected <= (long)bufSize4ES) {
                    int exp = (int)expected;
                    byte[] buffer = new byte[exp];
                    int count = 0;
                    int time = 0;
                    int len = 0;
                    do {
                        try {
                            len = is.read(buffer, count, buffer.length - count);
                            if (len < 0) {
                                if (isChunked) break;
                                throw new IOException("the server closes before sending " + cl + " bytes of data");
                            }
                            count += len;
                        }
                        catch (SocketTimeoutException ex) {
                            time += timeout4ESBuffer / 5;
                        }
                    } while (count < exp && time < timeout4ESBuffer);
                    http.setTimeout(oldTimeout);
                    if (count == 0) {
                        return null;
                    }
                    if ((long)count == expected && !isChunked || isChunked && len < 0) {
                        is.close();
                        return new ErrorStream(ByteBuffer.wrap(buffer, 0, count));
                    }
                    return new ErrorStream(ByteBuffer.wrap(buffer, 0, count), is);
                }
                return null;
            }
            catch (IOException ioex) {
                return null;
            }
        }

        @Override
        public int available() throws IOException {
            if (this.is == null) {
                return this.buffer.remaining();
            }
            return this.buffer.remaining() + this.is.available();
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int ret = this.read(b);
            return ret == -1 ? ret : b[0] & 0xFF;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int rem = this.buffer.remaining();
            if (rem > 0) {
                int ret = rem < len ? rem : len;
                this.buffer.get(b, off, ret);
                return ret;
            }
            if (this.is == null) {
                return -1;
            }
            return this.is.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.buffer = null;
            if (this.is != null) {
                this.is.close();
            }
        }
    }

    class StreamingOutputStream
    extends FilterOutputStream {
        long expected;
        long written;
        boolean closed;
        boolean error;
        IOException errorExcp;

        StreamingOutputStream(OutputStream os, long expectedLength) {
            super(os);
            this.expected = expectedLength;
            this.written = 0L;
            this.closed = false;
            this.error = false;
        }

        @Override
        public void write(int b) throws IOException {
            this.checkError();
            ++this.written;
            if (this.expected != -1L && this.written > this.expected) {
                throw new IOException("too many bytes written");
            }
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.checkError();
            this.written += (long)len;
            if (this.expected != -1L && this.written > this.expected) {
                this.out.close();
                throw new IOException("too many bytes written");
            }
            this.out.write(b, off, len);
        }

        void checkError() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (this.error) {
                throw this.errorExcp;
            }
            if (((PrintStream)this.out).checkError()) {
                throw new IOException("Error writing request body to server");
            }
        }

        boolean writtenOK() {
            return this.closed && !this.error;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.expected != -1L) {
                if (this.written != this.expected) {
                    this.error = true;
                    this.errorExcp = new IOException("insufficient data written");
                    this.out.close();
                    throw this.errorExcp;
                }
                super.flush();
            } else {
                super.close();
                OutputStream o = HttpURLConnection.this.http.getOutputStream();
                o.write(13);
                o.write(10);
                o.flush();
            }
        }
    }

    class HttpInputStream
    extends FilterInputStream {
        private CacheRequest cacheRequest;
        private OutputStream outputStream;
        private boolean marked;
        private int inCache;
        private int markCount;

        public HttpInputStream(InputStream is) {
            super(is);
            this.marked = false;
            this.inCache = 0;
            this.markCount = 0;
            this.cacheRequest = null;
            this.outputStream = null;
        }

        public HttpInputStream(InputStream is, CacheRequest cacheRequest) {
            super(is);
            this.marked = false;
            this.inCache = 0;
            this.markCount = 0;
            this.cacheRequest = cacheRequest;
            try {
                this.outputStream = cacheRequest.getBody();
            }
            catch (IOException ioex) {
                this.cacheRequest.abort();
                this.cacheRequest = null;
                this.outputStream = null;
            }
        }

        @Override
        public synchronized void mark(int readlimit) {
            super.mark(readlimit);
            if (this.cacheRequest != null) {
                this.marked = true;
                this.markCount = 0;
            }
        }

        @Override
        public synchronized void reset() throws IOException {
            super.reset();
            if (this.cacheRequest != null) {
                this.marked = false;
                this.inCache += this.markCount;
            }
        }

        @Override
        public int read() throws IOException {
            try {
                byte[] b = new byte[1];
                int ret = this.read(b);
                return ret == -1 ? ret : b[0] & 0xFF;
            }
            catch (IOException ioex) {
                if (this.cacheRequest != null) {
                    this.cacheRequest.abort();
                }
                throw ioex;
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int nWrite;
                int newLen = super.read(b, off, len);
                if (this.inCache > 0) {
                    if (this.inCache >= newLen) {
                        this.inCache -= newLen;
                        nWrite = 0;
                    } else {
                        nWrite = newLen - this.inCache;
                        this.inCache = 0;
                    }
                } else {
                    nWrite = newLen;
                }
                if (nWrite > 0 && this.outputStream != null) {
                    this.outputStream.write(b, off + (newLen - nWrite), nWrite);
                }
                if (this.marked) {
                    this.markCount += newLen;
                }
                return newLen;
            }
            catch (IOException ioex) {
                if (this.cacheRequest != null) {
                    this.cacheRequest.abort();
                }
                throw ioex;
            }
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.outputStream != null) {
                    if (this.read() != -1) {
                        this.cacheRequest.abort();
                    } else {
                        this.outputStream.close();
                    }
                }
                super.close();
            }
            catch (IOException ioex) {
                if (this.cacheRequest != null) {
                    this.cacheRequest.abort();
                }
                throw ioex;
            }
            finally {
                HttpURLConnection.this.http = null;
                HttpURLConnection.this.checkResponseCredentials(true);
            }
        }
    }

    static enum TunnelState {
        NONE,
        SETUP,
        TUNNELING;

    }
}

