/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.adapter.url.impl.net.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.CacheRequest;
import java.net.CookieHandler;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.ChunkedInputStream;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.HeaderParser;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.HttpURLConnection;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.KeepAliveCache;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.KeepAliveStream;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.MessageHeader;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.MeteredStream;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.NetworkClient;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.ParseUtil;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.PosterOutputStream;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.ProgressSource;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
extends NetworkClient {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClient.class);
    protected boolean cachedHttpClient = false;
    private boolean inCache;
    protected CookieHandler cookieHandler;
    MessageHeader requests;
    PosterOutputStream poster = null;
    boolean failedOnce = false;
    private static final int HTTP_CONTINUE = 100;
    protected static final int DEFAULT_HTTP_PORT = 80;
    protected String host;
    protected int port;
    protected static KeepAliveCache kac = new KeepAliveCache();
    private static boolean keepAliveProp = true;
    private static boolean retryPostProp = true;
    volatile boolean keepingAlive = false;
    int keepAliveConnections = -1;
    int keepAliveTimeout = 0;
    private CacheRequest cacheRequest = null;
    protected URL url;
    public boolean reuse = false;

    protected int getDefaultPort() {
        return 80;
    }

    @Deprecated
    public static synchronized void resetProperties() {
    }

    int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public boolean getHttpKeepAliveSet() {
        return keepAliveProp;
    }

    protected HttpClient(NetLayer lowerNetLayer, URL url, int to) throws IOException {
        super(lowerNetLayer);
        this.proxy = Proxy.NO_PROXY;
        this.host = url.getHost();
        this.url = url;
        this.port = url.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.setConnectTimeout(to);
        this.cookieHandler = AccessController.doPrivileged(new PrivilegedAction<CookieHandler>(){

            @Override
            public CookieHandler run() {
                return CookieHandler.getDefault();
            }
        });
        this.openServer();
    }

    public static HttpClient New(NetLayer lowerNetLayer, URL url) throws IOException {
        return HttpClient.New(lowerNetLayer, url, -1, true);
    }

    public static HttpClient New(NetLayer lowerNetLayer, URL url, boolean useCache) throws IOException {
        return HttpClient.New(lowerNetLayer, url, -1, useCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient New(NetLayer lowerNetLayer, URL url, int to, boolean useCache) throws IOException {
        Proxy p = Proxy.NO_PROXY;
        HttpClient ret = null;
        if (useCache && (ret = kac.get(url, null)) != null) {
            if (ret.proxy != null && ret.proxy.equals(p) || ret.proxy == null && p == null) {
                HttpClient httpClient = ret;
                synchronized (httpClient) {
                    ret.cachedHttpClient = true;
                    assert (ret.inCache);
                    ret.inCache = false;
                }
            } else {
                ret.inCache = false;
                ret.closeServer();
                ret = null;
            }
        }
        if (ret == null) {
            ret = new HttpClient(lowerNetLayer, url, to);
        } else {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkConnect(url.getHost(), url.getPort());
            }
            ret.url = url;
        }
        return ret;
    }

    public void finished() {
        if (this.reuse) {
            return;
        }
        --this.keepAliveConnections;
        this.poster = null;
        if (this.keepAliveConnections > 0 && this.isKeepingAlive() && !this.serverOutput.checkError()) {
            this.putInKeepAliveCache();
        } else {
            this.closeServer();
        }
    }

    protected synchronized void putInKeepAliveCache() {
        if (this.inCache) {
            assert (false) : "Duplicate put to keep alive cache";
            return;
        }
        this.inCache = true;
        kac.put(this.url, null, this);
    }

    protected boolean isInKeepAliveCache() {
        return this.inCache;
    }

    public void closeIdleConnection() {
        HttpClient http = kac.get(this.url, null);
        if (http != null) {
            http.closeServer();
        }
    }

    @Override
    public void openServer(String server, int port) throws IOException {
        this.serverSocket = this.doConnect(server, port);
        try {
            this.serverOutput = new PrintStream((OutputStream)new BufferedOutputStream(this.serverSocket.getOutputStream()), false, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(encoding + " encoding not found");
        }
    }

    public boolean needsTunneling() {
        return false;
    }

    public boolean isCachedConnection() {
        return this.cachedHttpClient;
    }

    public void afterConnect() throws IOException, UnknownHostException {
    }

    protected synchronized void openServer() throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkConnect(this.host, this.port);
        }
        if (this.keepingAlive) {
            return;
        }
        if (this.url.getProtocol().equals("http") || this.url.getProtocol().equals("https")) {
            this.openServer(this.host, this.port);
            return;
        }
        super.openServer(this.host, this.port);
    }

    public String getURLFile() throws IOException {
        String fileName = this.url.getFile();
        if (fileName == null || fileName.length() == 0) {
            fileName = "/";
        }
        if (fileName.indexOf(10) == -1) {
            return fileName;
        }
        throw new MalformedURLException("Illegal character in URL");
    }

    @Deprecated
    public void writeRequests(MessageHeader head) {
        this.requests = head;
        this.requests.print(this.serverOutput);
        this.serverOutput.flush();
    }

    public void writeRequests(MessageHeader head, PosterOutputStream pos) throws IOException {
        this.requests = head;
        this.requests.print(this.serverOutput);
        this.poster = pos;
        if (this.poster != null) {
            this.poster.writeTo(this.serverOutput);
        }
        this.serverOutput.flush();
    }

    public boolean parseHTTP(MessageHeader responses, ProgressSource pi, HttpURLConnection httpuc) throws IOException {
        try {
            this.serverInput = this.serverSocket.getInputStream();
            this.serverInput = new BufferedInputStream(this.serverInput);
            return this.parseHTTPHeader(responses, pi, httpuc);
        }
        catch (SocketTimeoutException stex) {
            this.closeServer();
            throw stex;
        }
        catch (IOException e) {
            this.closeServer();
            this.cachedHttpClient = false;
            if (!this.failedOnce && this.requests != null) {
                if (httpuc.getRequestMethod().equals("POST") && !retryPostProp) {
                    LOG.debug("do not retry request");
                } else {
                    this.failedOnce = true;
                    this.openServer();
                    if (this.needsTunneling()) {
                        httpuc.doTunneling();
                    }
                    this.afterConnect();
                    this.writeRequests(this.requests, this.poster);
                    return this.parseHTTP(responses, pi, httpuc);
                }
            }
            throw e;
        }
    }

    public int setTimeout(int timeout) throws SocketException {
        return -1;
    }

    private boolean parseHTTPHeader(MessageHeader responses, ProgressSource pi, HttpURLConnection httpuc) throws IOException {
        int nread;
        int r;
        this.keepAliveConnections = -1;
        this.keepAliveTimeout = 0;
        boolean ret = false;
        byte[] b = new byte[8];
        this.serverInput.mark(10);
        for (nread = 0; nread < 8 && (r = this.serverInput.read(b, nread, 8 - nread)) >= 0; nread += r) {
        }
        String keep = null;
        ret = b[0] == 72 && b[1] == 84 && b[2] == 84 && b[3] == 80 && b[4] == 47 && b[5] == 49 && b[6] == 46;
        this.serverInput.reset();
        if (ret) {
            URI uri;
            responses.parseHeader(this.serverInput);
            if (LOG.isDebugEnabled()) {
                LOG.debug("response header : {}", (Object)responses.toString());
            }
            if (this.cookieHandler != null && (uri = ParseUtil.toURI(this.url)) != null) {
                this.cookieHandler.put(uri, responses.getHeaders());
            }
            if (keep == null) {
                keep = responses.findValue("Connection");
            }
            if (keep != null && keep.toLowerCase().equals("keep-alive")) {
                HeaderParser p = new HeaderParser(responses.findValue("Keep-Alive"));
                if (p != null) {
                    boolean usingProxy = false;
                    this.keepAliveConnections = p.findInt("max", 5);
                    this.keepAliveTimeout = p.findInt("timeout", 5);
                }
            } else if (b[7] != 48) {
                this.keepAliveConnections = keep != null ? 1 : 5;
            }
        } else {
            if (nread != 8) {
                if (!this.failedOnce && this.requests != null) {
                    if (httpuc.getRequestMethod().equals("POST") && !retryPostProp) {
                        LOG.debug("do not retry request");
                    } else {
                        this.failedOnce = true;
                        this.closeServer();
                        this.cachedHttpClient = false;
                        this.openServer();
                        if (this.needsTunneling()) {
                            httpuc.doTunneling();
                        }
                        this.afterConnect();
                        this.writeRequests(this.requests, this.poster);
                        return this.parseHTTP(responses, pi, httpuc);
                    }
                }
                throw new SocketException("Unexpected end of file from server");
            }
            responses.set("Content-type", "unknown/unknown");
        }
        int code = -1;
        try {
            String resp = responses.getValue(0);
            int ind = resp.indexOf(32);
            while (resp.charAt(ind) == ' ') {
                ++ind;
            }
            code = Integer.parseInt(resp.substring(ind, ind + 3));
        }
        catch (Exception e) {
            LOG.debug("got Exception while trying to extract the status code : {}", (Object)e, (Object)e);
        }
        if (code == 100) {
            responses.reset();
            return this.parseHTTPHeader(responses, pi, httpuc);
        }
        long cl = -1L;
        String te = null;
        try {
            te = responses.findValue("Transfer-Encoding");
        }
        catch (Exception e) {
            LOG.debug("got Exception while retrieving Transfer-Encoding value : {}", (Object)e, (Object)e);
        }
        if (te != null && te.equalsIgnoreCase("chunked")) {
            this.serverInput = new ChunkedInputStream(this.serverInput, this, responses);
            if (this.keepAliveConnections <= 1) {
                this.keepAliveConnections = 1;
                this.keepingAlive = false;
            } else {
                this.keepingAlive = true;
            }
            this.failedOnce = false;
        } else {
            try {
                cl = Long.parseLong(responses.findValue("content-length"));
            }
            catch (Exception e) {
                LOG.debug("got Exception while trying to retrieve content-length value: {}", (Object)e, (Object)e);
            }
            String requestLine = this.requests.getKey(0);
            if (requestLine != null && requestLine.startsWith("HEAD") || code == 304 || code == 204) {
                cl = 0L;
            }
            if (this.keepAliveConnections > 1 && (cl >= 0L || code == 304 || code == 204)) {
                this.keepingAlive = true;
                this.failedOnce = false;
            } else if (this.keepingAlive) {
                this.keepingAlive = false;
            }
        }
        if (cl > 0L) {
            if (pi != null) {
                pi.setContentType(responses.findValue("content-type"));
            }
            if (this.isKeepingAlive()) {
                this.serverInput = new KeepAliveStream(this.serverInput, pi, cl, this);
                this.failedOnce = false;
            } else {
                this.serverInput = new MeteredStream(this.serverInput, pi, cl);
            }
        } else if (cl == -1L) {
            if (pi != null) {
                pi.setContentType(responses.findValue("content-type"));
                this.serverInput = new MeteredStream(this.serverInput, pi, cl);
            }
        } else if (pi != null) {
            pi.finishTracking();
        }
        return ret;
    }

    public synchronized InputStream getInputStream() {
        return this.serverInput;
    }

    public OutputStream getOutputStream() {
        return this.serverOutput;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.url + ")";
    }

    public final boolean isKeepingAlive() {
        return this.getHttpKeepAliveSet() && this.keepingAlive;
    }

    public void setCacheRequest(CacheRequest cacheRequest) {
        this.cacheRequest = cacheRequest;
    }

    CacheRequest getCacheRequest() {
        return this.cacheRequest;
    }

    protected void finalize() throws Throwable {
    }

    public void setDoNotRetry(boolean value) {
        this.failedOnce = value;
    }

    @Override
    public void closeServer() {
        try {
            this.keepingAlive = false;
            this.serverSocket.close();
        }
        catch (Exception e) {
            LOG.debug("got Exception trying to close the socket : {}", (Object)e, (Object)e);
        }
    }

    public String getProxyHostUsed() {
        return null;
    }

    public int getProxyPortUsed() {
        return -1;
    }

    static {
        String keepAlive = System.getProperty("http.keepAlive");
        String retryPost = System.getProperty("sun.net.http.retryPost");
        keepAliveProp = keepAlive != null ? Boolean.valueOf(keepAlive) : true;
        retryPostProp = retryPost != null ? Boolean.valueOf(retryPost) : true;
    }
}

