/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.adapter.url.impl.net.http;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.AuthenticationInfo;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.HeaderParser;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.HttpURLConnection;

class DigestAuthentication
extends AuthenticationInfo {
    private static final long serialVersionUID = 100L;
    static String HTTP_CONNECT = "CONNECT";
    static final char DIGEST_AUTH = 'D';
    private String authMethod;
    Parameters params;
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String[] ZEROPAD = new String[]{"00000000", "0000000", "000000", "00000", "0000", "000", "00", "0"};

    public DigestAuthentication(boolean isProxy, URL url, String realm, String authMethod, PasswordAuthentication pw, Parameters params) {
        super(isProxy ? (char)'p' : 's', 'D', url, realm);
        this.authMethod = authMethod;
        this.pw = pw;
        this.params = params;
    }

    public DigestAuthentication(boolean isProxy, String host, int port, String realm, String authMethod, PasswordAuthentication pw, Parameters params) {
        super(isProxy ? (char)'p' : 's', 'D', host, port, realm);
        this.authMethod = authMethod;
        this.pw = pw;
        this.params = params;
    }

    @Override
    boolean supportsPreemptiveAuthorization() {
        return true;
    }

    @Override
    String getHeaderName() {
        if (this.type == 's') {
            return "Authorization";
        }
        return "Proxy-Authorization";
    }

    @Override
    String getHeaderValue(URL url, String method) {
        return this.getHeaderValueImpl(url.getFile(), method);
    }

    String getHeaderValue(String requestURI, String method) {
        return this.getHeaderValueImpl(requestURI, method);
    }

    @Override
    boolean isAuthorizationStale(String header) {
        HeaderParser p = new HeaderParser(header);
        String s = p.findValue("stale");
        if (s == null || !s.equals("true")) {
            return false;
        }
        String newNonce = p.findValue("nonce");
        if (newNonce == null || "".equals(newNonce)) {
            return false;
        }
        this.params.setNonce(newNonce);
        return true;
    }

    @Override
    boolean setHeaders(HttpURLConnection conn, HeaderParser p, String raw) {
        String value;
        String algorithm;
        String method;
        String uri;
        this.params.setNonce(p.findValue("nonce"));
        this.params.setOpaque(p.findValue("opaque"));
        this.params.setQop(p.findValue("qop"));
        if (this.type == 'p' && conn.tunnelState() == HttpURLConnection.TunnelState.SETUP) {
            uri = HttpURLConnection.connectRequestURI(conn.getURL());
            method = HTTP_CONNECT;
        } else {
            uri = conn.getURL().getFile();
            method = conn.getMethod();
        }
        if (this.params.nonce == null || this.authMethod == null || this.pw == null || this.realm == null) {
            return false;
        }
        if (this.authMethod.length() >= 1) {
            this.authMethod = Character.toUpperCase(this.authMethod.charAt(0)) + this.authMethod.substring(1).toLowerCase();
        }
        if ((algorithm = p.findValue("algorithm")) == null || "".equals(algorithm)) {
            algorithm = "MD5";
        }
        this.params.setAlgorithm(algorithm);
        if (this.params.authQop()) {
            this.params.setNewCnonce();
        }
        if ((value = this.getHeaderValueImpl(uri, method)) != null) {
            conn.setAuthenticationProperty(this.getHeaderName(), value);
            return true;
        }
        return false;
    }

    private String getHeaderValueImpl(String uri, String method) {
        String response;
        int len;
        char[] passwd = this.pw.getPassword();
        boolean qop = this.params.authQop();
        String opaque = this.params.getOpaque();
        String cnonce = this.params.getCnonce();
        String nonce = this.params.getNonce();
        String algorithm = this.params.getAlgorithm();
        this.params.incrementNC();
        int nccount = this.params.getNCCount();
        String ncstring = null;
        if (nccount != -1 && (len = (ncstring = Integer.toHexString(nccount).toLowerCase()).length()) < 8) {
            ncstring = ZEROPAD[len] + ncstring;
        }
        try {
            response = this.computeDigest(true, this.pw.getUserName(), passwd, this.realm, method, uri, nonce, cnonce, ncstring);
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
        String ncfield = "\"";
        if (qop) {
            ncfield = "\", nc=" + ncstring;
        }
        String value = this.authMethod + " username=\"" + this.pw.getUserName() + "\", realm=\"" + this.realm + "\", nonce=\"" + nonce + ncfield + ", uri=\"" + uri + "\", response=\"" + response + "\", algorithm=\"" + algorithm;
        if (opaque != null) {
            value = value + "\", opaque=\"" + opaque;
        }
        if (cnonce != null) {
            value = value + "\", cnonce=\"" + cnonce;
        }
        if (qop) {
            value = value + "\", qop=\"auth";
        }
        value = value + "\"";
        return value;
    }

    @Override
    public void checkResponse(String header, String method, URL url) throws IOException {
        int len;
        String uri = url.getFile();
        char[] passwd = this.pw.getPassword();
        String username = this.pw.getUserName();
        boolean qop = this.params.authQop();
        String opaque = this.params.getOpaque();
        String cnonce = this.params.cnonce;
        String nonce = this.params.getNonce();
        String algorithm = this.params.getAlgorithm();
        int nccount = this.params.getNCCount();
        String ncstring = null;
        if (header == null) {
            throw new ProtocolException("No authentication information in response");
        }
        if (nccount != -1 && (len = (ncstring = Integer.toHexString(nccount).toUpperCase()).length()) < 8) {
            ncstring = ZEROPAD[len] + ncstring;
        }
        try {
            String expected = this.computeDigest(false, username, passwd, this.realm, method, uri, nonce, cnonce, ncstring);
            HeaderParser p = new HeaderParser(header);
            String rspauth = p.findValue("rspauth");
            if (rspauth == null) {
                throw new ProtocolException("No digest in response");
            }
            if (!rspauth.equals(expected)) {
                throw new ProtocolException("Response digest invalid");
            }
            String nextnonce = p.findValue("nextnonce");
            if (nextnonce != null && !"".equals(nextnonce)) {
                this.params.setNonce(nextnonce);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ProtocolException("Unsupported algorithm in response");
        }
    }

    private String computeDigest(boolean isRequest, String userName, char[] password, String realm, String connMethod, String requestURI, String nonceString, String cnonce, String ncValue) throws NoSuchAlgorithmException {
        String HashA1;
        String algorithm = this.params.getAlgorithm();
        boolean md5sess = algorithm.equalsIgnoreCase("MD5-sess");
        MessageDigest md = MessageDigest.getInstance(md5sess ? "MD5" : algorithm);
        if (md5sess) {
            HashA1 = this.params.getCachedHA1();
            if (HashA1 == null) {
                String s = userName + ":" + realm + ":";
                String s1 = this.encode(s, password, md);
                String A1 = s1 + ":" + nonceString + ":" + cnonce;
                HashA1 = this.encode(A1, null, md);
                this.params.setCachedHA1(HashA1);
            }
        } else {
            String A1 = userName + ":" + realm + ":";
            HashA1 = this.encode(A1, password, md);
        }
        String A2 = isRequest ? connMethod + ":" + requestURI : ":" + requestURI;
        String HashA2 = this.encode(A2, null, md);
        String combo = this.params.authQop() ? HashA1 + ":" + nonceString + ":" + ncValue + ":" + cnonce + ":auth:" + HashA2 : HashA1 + ":" + nonceString + ":" + HashA2;
        String finalHash = this.encode(combo, null, md);
        return finalHash;
    }

    private String encode(String src, char[] passwd, MessageDigest md) {
        block5: {
            try {
                md.update(src.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException uee) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        if (passwd != null) {
            byte[] passwdBytes = new byte[passwd.length];
            for (int i = 0; i < passwd.length; ++i) {
                passwdBytes[i] = (byte)passwd[i];
            }
            md.update(passwdBytes);
            Arrays.fill(passwdBytes, (byte)0);
        }
        byte[] digest = md.digest();
        StringBuffer res = new StringBuffer(digest.length * 2);
        for (int i = 0; i < digest.length; ++i) {
            int hashchar = digest[i] >>> 4 & 0xF;
            res.append(HEX_CHARS[hashchar]);
            hashchar = digest[i] & 0xF;
            res.append(HEX_CHARS[hashchar]);
        }
        return res.toString();
    }

    static class Parameters
    implements Serializable {
        private static final long serialVersionUID = -3584543755194526252L;
        private boolean serverQop = false;
        private String opaque = null;
        private String cnonce;
        private String nonce = null;
        private String algorithm = null;
        private int NCcount = 0;
        private String cachedHA1 = null;
        private boolean redoCachedHA1 = true;
        private static final int cnonceRepeat = 5;
        private static final int cnoncelen = 40;
        private static SecureRandom random = new SecureRandom();
        int cnonceCount = 0;

        Parameters() {
            this.setNewCnonce();
        }

        boolean authQop() {
            return this.serverQop;
        }

        synchronized void incrementNC() {
            ++this.NCcount;
        }

        synchronized int getNCCount() {
            return this.NCcount;
        }

        synchronized String getCnonce() {
            if (this.cnonceCount >= 5) {
                this.setNewCnonce();
            }
            ++this.cnonceCount;
            return this.cnonce;
        }

        synchronized void setNewCnonce() {
            byte[] bb = new byte[20];
            char[] cc = new char[40];
            random.nextBytes(bb);
            for (int i = 0; i < 20; ++i) {
                int x = bb[i] + 128;
                cc[i * 2] = (char)(65 + x / 16);
                cc[i * 2 + 1] = (char)(65 + x % 16);
            }
            this.cnonce = new String(cc, 0, 40);
            this.cnonceCount = 0;
            this.redoCachedHA1 = true;
        }

        synchronized void setQop(String qop) {
            if (qop != null) {
                StringTokenizer st = new StringTokenizer(qop, " ");
                while (st.hasMoreTokens()) {
                    if (!st.nextToken().equalsIgnoreCase("auth")) continue;
                    this.serverQop = true;
                    return;
                }
            }
            this.serverQop = false;
        }

        synchronized String getOpaque() {
            return this.opaque;
        }

        synchronized void setOpaque(String s) {
            this.opaque = s;
        }

        synchronized String getNonce() {
            return this.nonce;
        }

        synchronized void setNonce(String s) {
            if (!s.equals(this.nonce)) {
                this.nonce = s;
                this.NCcount = 0;
                this.redoCachedHA1 = true;
            }
        }

        synchronized String getCachedHA1() {
            if (this.redoCachedHA1) {
                return null;
            }
            return this.cachedHA1;
        }

        synchronized void setCachedHA1(String s) {
            this.cachedHA1 = s;
            this.redoCachedHA1 = false;
        }

        synchronized String getAlgorithm() {
            return this.algorithm;
        }

        synchronized void setAlgorithm(String s) {
            this.algorithm = s;
        }
    }
}

