/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.adapter.url.impl.net.http;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.AuthCacheValue;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.HeaderParser;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.HttpURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AuthenticationInfo
extends AuthCacheValue
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(AuthCacheValue.class);
    private static final long serialVersionUID = 1L;
    protected static final char SERVER_AUTHENTICATION = 's';
    protected static final char PROXY_AUTHENTICATION = 'p';
    static boolean serializeAuth = "true".equalsIgnoreCase(System.getProperty("http.auth.serializeRequests"));
    protected transient PasswordAuthentication pw;
    private static HashMap<String, Thread> requests = new HashMap();
    char type;
    char authType;
    String protocol;
    String host;
    int port;
    String realm;
    String path;
    String s1;
    String s2;

    @Override
    public PasswordAuthentication credentials() {
        return this.pw;
    }

    @Override
    public AuthCacheValue.Type getAuthType() {
        return this.type == 's' ? AuthCacheValue.Type.Server : AuthCacheValue.Type.Proxy;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getProtocolScheme() {
        return this.protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean requestIsInProgress(String key) {
        if (!serializeAuth) {
            return false;
        }
        HashMap<String, Thread> hashMap = requests;
        synchronized (hashMap) {
            Thread c = Thread.currentThread();
            Thread t = requests.get(key);
            if (t == null) {
                requests.put(key, c);
                return false;
            }
            if (t == c) {
                return false;
            }
            while (requests.containsKey(key)) {
                try {
                    requests.wait();
                }
                catch (InterruptedException e) {
                    LOG.debug("got IterruptedException : ", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void requestCompleted(String key) {
        HashMap<String, Thread> hashMap = requests;
        synchronized (hashMap) {
            boolean waspresent;
            boolean bl = waspresent = requests.remove(key) != null;
            assert (waspresent);
            requests.notifyAll();
        }
    }

    AuthenticationInfo(char type, char authType, String host, int port, String realm) {
        this.type = type;
        this.authType = authType;
        this.protocol = "";
        this.host = host.toLowerCase();
        this.port = port;
        this.realm = realm;
        this.path = null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    AuthenticationInfo(char type, char authType, URL url, String realm) {
        this.type = type;
        this.authType = authType;
        this.protocol = url.getProtocol().toLowerCase();
        this.host = url.getHost().toLowerCase();
        this.port = url.getPort();
        if (this.port == -1) {
            this.port = url.getDefaultPort();
        }
        this.realm = realm;
        String urlPath = url.getPath();
        this.path = urlPath.length() == 0 ? urlPath : AuthenticationInfo.reducePath(urlPath);
    }

    static String reducePath(String urlPath) {
        int sepIndex = urlPath.lastIndexOf(47);
        int targetSuffixIndex = urlPath.lastIndexOf(46);
        if (sepIndex != -1) {
            if (sepIndex < targetSuffixIndex) {
                return urlPath.substring(0, sepIndex + 1);
            }
            return urlPath;
        }
        return urlPath;
    }

    static AuthenticationInfo getServerAuth(URL url) {
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        String key = "s:" + url.getProtocol().toLowerCase() + ":" + url.getHost().toLowerCase() + ":" + port;
        return AuthenticationInfo.getAuth(key, url);
    }

    static AuthenticationInfo getServerAuth(URL url, String realm, char atype) {
        String key;
        AuthenticationInfo cached;
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        if ((cached = AuthenticationInfo.getAuth(key = "s:" + atype + ":" + url.getProtocol().toLowerCase() + ":" + url.getHost().toLowerCase() + ":" + port + ":" + realm, null)) == null && AuthenticationInfo.requestIsInProgress(key)) {
            cached = AuthenticationInfo.getAuth(key, null);
        }
        return cached;
    }

    static AuthenticationInfo getAuth(String key, URL url) {
        if (url == null) {
            return (AuthenticationInfo)cache.get(key, null);
        }
        return (AuthenticationInfo)cache.get(key, url.getPath());
    }

    static AuthenticationInfo getProxyAuth(String host, int port) {
        String key = "p::" + host.toLowerCase() + ":" + port;
        AuthenticationInfo result = (AuthenticationInfo)cache.get(key, null);
        return result;
    }

    static AuthenticationInfo getProxyAuth(String host, int port, String realm, char atype) {
        String key = "p:" + atype + "::" + host.toLowerCase() + ":" + port + ":" + realm;
        AuthenticationInfo cached = (AuthenticationInfo)cache.get(key, null);
        if (cached == null && AuthenticationInfo.requestIsInProgress(key)) {
            cached = (AuthenticationInfo)cache.get(key, null);
        }
        return cached;
    }

    void addToCache() {
        cache.put(this.cacheKey(true), this);
        if (this.supportsPreemptiveAuthorization()) {
            cache.put(this.cacheKey(false), this);
        }
        this.endAuthRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endAuthRequest() {
        if (!serializeAuth) {
            return;
        }
        HashMap<String, Thread> hashMap = requests;
        synchronized (hashMap) {
            AuthenticationInfo.requestCompleted(this.cacheKey(true));
        }
    }

    void removeFromCache() {
        cache.remove(this.cacheKey(true), this);
        if (this.supportsPreemptiveAuthorization()) {
            cache.remove(this.cacheKey(false), this);
        }
    }

    abstract boolean supportsPreemptiveAuthorization();

    abstract String getHeaderName();

    abstract String getHeaderValue(URL var1, String var2);

    abstract boolean setHeaders(HttpURLConnection var1, HeaderParser var2, String var3);

    abstract boolean isAuthorizationStale(String var1);

    abstract void checkResponse(String var1, String var2, URL var3) throws IOException;

    String cacheKey(boolean includeRealm) {
        if (includeRealm) {
            return this.type + ":" + this.authType + ":" + this.protocol + ":" + this.host + ":" + this.port + ":" + this.realm;
        }
        return this.type + ":" + this.protocol + ":" + this.host + ":" + this.port;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.pw = new PasswordAuthentication(this.s1, this.s2.toCharArray());
        this.s1 = null;
        this.s2 = null;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        this.s1 = this.pw.getUserName();
        this.s2 = new String(this.pw.getPassword());
        s.defaultWriteObject();
    }
}

