/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.adapter.url.impl.net.http;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.HeaderParser;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.MessageHeader;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.NegotiateAuthentication;

public class AuthenticationHeader {
    MessageHeader rsp;
    HeaderParser preferred;
    String preferredRaw;
    String host = null;
    static String authPref = null;
    String hdrname;
    HashMap<String, SchemeMapValue> schemes;

    public String toString() {
        return "AuthenticationHeader: prefer " + this.preferredRaw;
    }

    public AuthenticationHeader(String hdrname, MessageHeader response) {
        this.rsp = response;
        this.hdrname = hdrname;
        this.schemes = new HashMap();
        this.parse();
    }

    public AuthenticationHeader(String hdrname, MessageHeader response, String host) {
        this.host = host;
        this.rsp = response;
        this.hdrname = hdrname;
        this.schemes = new HashMap();
        this.parse();
    }

    private void parse() {
        Iterator<String> iter = this.rsp.multiValueIterator(this.hdrname);
        while (iter.hasNext()) {
            String scheme;
            HeaderParser hpn;
            String raw = iter.next();
            HeaderParser hp = new HeaderParser(raw);
            Iterator<Object> keys = hp.keys();
            int i = 0;
            int lastSchemeIndex = -1;
            while (keys.hasNext()) {
                keys.next();
                if (hp.findValue(i) == null) {
                    if (lastSchemeIndex != -1) {
                        hpn = hp.subsequence(lastSchemeIndex, i);
                        scheme = hpn.findKey(0);
                        this.schemes.put(scheme, new SchemeMapValue(hpn, raw));
                    }
                    lastSchemeIndex = i;
                }
                ++i;
            }
            if (i <= lastSchemeIndex) continue;
            hpn = hp.subsequence(lastSchemeIndex, i);
            scheme = hpn.findKey(0);
            this.schemes.put(scheme, new SchemeMapValue(hpn, raw));
        }
        SchemeMapValue v = null;
        if (authPref == null || (v = this.schemes.get(authPref)) == null) {
            SchemeMapValue tmp;
            if (v == null && (tmp = this.schemes.get("negotiate")) != null) {
                if (this.host == null || !NegotiateAuthentication.isSupported(this.host, "Negotiate")) {
                    tmp = null;
                }
                v = tmp;
            }
            if (v == null && (tmp = this.schemes.get("kerberos")) != null) {
                if (this.host == null || !NegotiateAuthentication.isSupported(this.host, "Kerberos")) {
                    tmp = null;
                }
                v = tmp;
            }
            if (v == null && (v = this.schemes.get("digest")) == null && (v = this.schemes.get("ntlm")) == null) {
                v = this.schemes.get("basic");
            }
        }
        if (v != null) {
            this.preferred = v.parser;
            this.preferredRaw = v.raw;
        }
    }

    public HeaderParser headerParser() {
        return this.preferred;
    }

    public String scheme() {
        if (this.preferred != null) {
            return this.preferred.findKey(0);
        }
        return null;
    }

    public String raw() {
        return this.preferredRaw;
    }

    public boolean isPresent() {
        return this.preferred != null;
    }

    static {
        authPref = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("http.auth.preference");
            }
        });
        if (authPref != null && ((authPref = authPref.toLowerCase()).equals("spnego") || authPref.equals("kerberos"))) {
            authPref = "negotiate";
        }
    }

    static class SchemeMapValue {
        String raw;
        HeaderParser parser;

        SchemeMapValue(HeaderParser h, String r) {
            this.raw = r;
            this.parser = h;
        }
    }
}

