/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.adapter.url;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;
import org.silvertunnel_ng.netlib.adapter.url.InvalidURLStreamHandler;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.http.HttpHandler;
import org.silvertunnel_ng.netlib.adapter.url.impl.net.https.HttpsHandler;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.layer.tls.TLSNetLayer;

public class NetlibURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    private static final String PROTOCOL_FTP = "ftp";
    private Map<String, URLStreamHandler> handlers;
    private final boolean prohibitAccessForOtherProtocols;

    public NetlibURLStreamHandlerFactory() {
        this(false);
    }

    public NetlibURLStreamHandlerFactory(boolean prohibitAccessForOtherProtocols) {
        this(new HashMap<String, URLStreamHandler>(), prohibitAccessForOtherProtocols);
    }

    public NetlibURLStreamHandlerFactory(Map<String, URLStreamHandler> handlers, boolean prohibitAccessForOtherProtocols) {
        this.handlers = handlers;
        this.prohibitAccessForOtherProtocols = prohibitAccessForOtherProtocols;
    }

    public NetlibURLStreamHandlerFactory(NetLayer tcpipNetLayer, NetLayer tlsNetLayer, boolean prohibitAccessForOtherProtocols) {
        this.setNetLayerForHttpHttpsFtp(tcpipNetLayer, tlsNetLayer);
        this.prohibitAccessForOtherProtocols = prohibitAccessForOtherProtocols;
    }

    public NetlibURLStreamHandlerFactory(NetLayer tcpipNetLayer, boolean prohibitAccessForOtherProtocols) {
        this.setNetLayerForHttpHttpsFtp(tcpipNetLayer);
        this.prohibitAccessForOtherProtocols = prohibitAccessForOtherProtocols;
    }

    public final synchronized void setNetLayerForHttpHttpsFtp(NetLayer tcpipNetLayer, NetLayer tlsNetLayer) {
        URLStreamHandler handler;
        if (this.handlers == null) {
            this.handlers = new HashMap<String, URLStreamHandler>();
        }
        if ((handler = this.handlers.get(PROTOCOL_HTTP)) != null && handler instanceof HttpHandler) {
            ((HttpHandler)handler).setNetLayer(tcpipNetLayer);
        } else {
            this.handlers.put(PROTOCOL_HTTP, new HttpHandler(tcpipNetLayer));
        }
        handler = this.handlers.get(PROTOCOL_HTTPS);
        if (handler != null && handler instanceof HttpHandler) {
            ((HttpsHandler)handler).setNetLayer(tlsNetLayer);
        } else {
            this.handlers.put(PROTOCOL_HTTPS, new HttpsHandler(tlsNetLayer));
        }
    }

    public void setNetLayerForHttpHttpsFtp(NetLayer tcpipNetLayer) {
        this.setNetLayerForHttpHttpsFtp(tcpipNetLayer, new TLSNetLayer(tcpipNetLayer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandler result;
        NetlibURLStreamHandlerFactory netlibURLStreamHandlerFactory = this;
        synchronized (netlibURLStreamHandlerFactory) {
            result = this.handlers.get(protocol);
        }
        if (result != null) {
            return result;
        }
        if (this.prohibitAccessForOtherProtocols) {
            return new InvalidURLStreamHandler();
        }
        return null;
    }
}

