/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.adapter.nameservice;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.silvertunnel_ng.netlib.adapter.nameservice.NameServiceNetlibGenericAdapter;
import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.NetAddressNameService;
import org.silvertunnel_ng.netlib.api.util.IpNetAddress;
import org.silvertunnel_ng.netlib.nameservice.redirect.SwitchingNetAddressNameService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NameServiceNetlibAdapter
implements NameServiceNetlibGenericAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(NameServiceNetlibAdapter.class);
    private final NetAddressNameService netAddressNameService;

    NameServiceNetlibAdapter(NetAddressNameService netAddressNameService) {
        this.netAddressNameService = netAddressNameService;
    }

    @Override
    public String getHostByAddr(byte[] ip) throws UnknownHostException {
        LOG.info("getHostByAddr(ip={})", (Object)Arrays.toString(ip));
        String[] result = this.netAddressNameService.getNamesByAddress(new IpNetAddress(ip));
        return result[0];
    }

    @Override
    public InetAddress[] lookupAllHostAddrJava6(String name) throws UnknownHostException {
        String netAddressNS = "unknown";
        if (this.netAddressNameService.getClass().equals(SwitchingNetAddressNameService.class)) {
            netAddressNS = ((SwitchingNetAddressNameService)this.netAddressNameService).getLowerNetAddressNameServiceClass();
        }
        LOG.info("InetAddress[] lookupAllHostAddrJava6(name={} netAddressNameService={})", (Object)name, (Object)netAddressNS);
        NetAddress[] result = this.netAddressNameService.getAddressesByName(name);
        InetAddress[] resultFinal = new InetAddress[result.length];
        for (int i = 0; i < result.length; ++i) {
            resultFinal[i] = ((IpNetAddress)result[i]).getIpaddressAsInetAddress();
        }
        return resultFinal;
    }
}

