/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip.util;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class InMemoryRandomAccessFile {
    private final transient byte[] data;
    private transient int position;

    public InMemoryRandomAccessFile(byte[] dataSource) {
        this.data = dataSource;
        this.position = 0;
    }

    public InMemoryRandomAccessFile(InputStream dataSource, int maxSize) throws IOException {
        this(InMemoryRandomAccessFile.getBytesOfInputStream(dataSource, maxSize));
    }

    public static byte[] getBytesOfInputStream(InputStream inputStream, int maxSize) throws IOException {
        int readBytes;
        if (inputStream == null) {
            throw new IOException("invalid inputStream=null");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        int totalReadBytes = 0;
        while ((readBytes = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, readBytes);
            if ((totalReadBytes += readBytes) <= maxSize) continue;
        }
        byte[] result = outputStream.toByteArray();
        inputStream.close();
        outputStream.close();
        return result;
    }

    public void close() {
    }

    public int read() throws IOException {
        if (this.position >= this.data.length) {
            return -1;
        }
        return this.data[this.position++];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("");
        }
        int numberOfBytesCopied = 0;
        while (off < b.length && this.position < this.data.length && len > 0) {
            b[off] = this.data[this.position];
            ++off;
            ++this.position;
            ++numberOfBytesCopied;
            --len;
        }
        return numberOfBytesCopied;
    }

    public long length() throws IOException {
        return this.data.length;
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L || pos >= this.length() || pos > Integer.MAX_VALUE) {
            throw new IOException("seek() tried with invalid position=" + pos);
        }
        this.position = (int)pos;
    }

    public long getFilePointer() throws IOException {
        return this.position;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }
}

