/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip;

import com.maxmind.geoip.Country;
import com.maxmind.geoip.DatabaseInfo;
import com.maxmind.geoip.Location;
import com.maxmind.geoip.util.InMemoryRandomAccessFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LookupService {
    private static final Logger LOG = LoggerFactory.getLogger(LookupService.class);
    private InMemoryRandomAccessFile file = null;
    private DatabaseInfo databaseInfo = null;
    byte databaseType = 1;
    int[] databaseSegments;
    int recordLength;
    String licenseKey;
    int dnsService = 0;
    int dboptions;
    byte[] dbbuffer;
    byte[] index_cache;
    private static final int COUNTRY_BEGIN = 0xFFFF00;
    private static final int STATE_BEGIN_REV0 = 16700000;
    private static final int STATE_BEGIN_REV1 = 16000000;
    private static final int STRUCTURE_INFO_MAX_SIZE = 20;
    private static final int DATABASE_INFO_MAX_SIZE = 100;
    public static final int GEOIP_STANDARD = 0;
    public static final int GEOIP_MEMORY_CACHE = 1;
    public static final int GEOIP_CHECK_CACHE = 2;
    public static final int GEOIP_INDEX_CACHE = 4;
    public static final int GEOIP_UNKNOWN_SPEED = 0;
    public static final int GEOIP_DIALUP_SPEED = 1;
    public static final int GEOIP_CABLEDSL_SPEED = 2;
    public static final int GEOIP_CORPORATE_SPEED = 3;
    private static final int SEGMENT_RECORD_LENGTH = 3;
    private static final int STANDARD_RECORD_LENGTH = 3;
    private static final int ORG_RECORD_LENGTH = 4;
    private static final int MAX_RECORD_LENGTH = 4;
    private static final int FULL_RECORD_LENGTH = 60;
    private static final Country UNKNOWN_COUNTRY = new Country("--", "N/A");
    private static final HashMap<String, Integer> hashmapcountryCodetoindex = new HashMap(512);
    private static final HashMap<String, Integer> hashmapcountryNametoindex = new HashMap(512);
    private static final String[] COUNTRY_CODE = new String[]{"--", "AP", "EU", "AD", "AE", "AF", "AG", "AI", "AL", "AM", "AN", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "FX", "GA", "GB", "GD", "GE", "GF", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IN", "IO", "IQ", "IR", "IS", "IT", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TM", "TN", "TO", "TL", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "RS", "ZA", "ZM", "ME", "ZW", "A1", "A2", "O1", "AX", "GG", "IM", "JE", "BL", "MF"};
    private static final String[] COUNTRY_NAME = new String[]{"N/A", "Asia/Pacific Region", "Europe", "Andorra", "United Arab Emirates", "Afghanistan", "Antigua and Barbuda", "Anguilla", "Albania", "Armenia", "Netherlands Antilles", "Angola", "Antarctica", "Argentina", "American Samoa", "Austria", "Australia", "Aruba", "Azerbaijan", "Bosnia and Herzegovina", "Barbados", "Bangladesh", "Belgium", "Burkina Faso", "Bulgaria", "Bahrain", "Burundi", "Benin", "Bermuda", "Brunei Darussalam", "Bolivia", "Brazil", "Bahamas", "Bhutan", "Bouvet Island", "Botswana", "Belarus", "Belize", "Canada", "Cocos (Keeling) Islands", "Congo, The Democratic Republic of the", "Central African Republic", "Congo", "Switzerland", "Cote D'Ivoire", "Cook Islands", "Chile", "Cameroon", "China", "Colombia", "Costa Rica", "Cuba", "Cape Verde", "Christmas Island", "Cyprus", "Czech Republic", "Germany", "Djibouti", "Denmark", "Dominica", "Dominican Republic", "Algeria", "Ecuador", "Estonia", "Egypt", "Western Sahara", "Eritrea", "Spain", "Ethiopia", "Finland", "Fiji", "Falkland Islands (Malvinas)", "Micronesia, Federated States of", "Faroe Islands", "France", "France, Metropolitan", "Gabon", "United Kingdom", "Grenada", "Georgia", "French Guiana", "Ghana", "Gibraltar", "Greenland", "Gambia", "Guinea", "Guadeloupe", "Equatorial Guinea", "Greece", "South Georgia and the South Sandwich Islands", "Guatemala", "Guam", "Guinea-Bissau", "Guyana", "Hong Kong", "Heard Island and McDonald Islands", "Honduras", "Croatia", "Haiti", "Hungary", "Indonesia", "Ireland", "Israel", "India", "British Indian Ocean Territory", "Iraq", "Iran, Islamic Republic of", "Iceland", "Italy", "Jamaica", "Jordan", "Japan", "Kenya", "Kyrgyzstan", "Cambodia", "Kiribati", "Comoros", "Saint Kitts and Nevis", "Korea, Democratic People's Republic of", "Korea, Republic of", "Kuwait", "Cayman Islands", "Kazakhstan", "Lao People's Democratic Republic", "Lebanon", "Saint Lucia", "Liechtenstein", "Sri Lanka", "Liberia", "Lesotho", "Lithuania", "Luxembourg", "Latvia", "Libyan Arab Jamahiriya", "Morocco", "Monaco", "Moldova, Republic of", "Madagascar", "Marshall Islands", "Macedonia", "Mali", "Myanmar", "Mongolia", "Macau", "Northern Mariana Islands", "Martinique", "Mauritania", "Montserrat", "Malta", "Mauritius", "Maldives", "Malawi", "Mexico", "Malaysia", "Mozambique", "Namibia", "New Caledonia", "Niger", "Norfolk Island", "Nigeria", "Nicaragua", "Netherlands", "Norway", "Nepal", "Nauru", "Niue", "New Zealand", "Oman", "Panama", "Peru", "French Polynesia", "Papua New Guinea", "Philippines", "Pakistan", "Poland", "Saint Pierre and Miquelon", "Pitcairn Islands", "Puerto Rico", "Palestinian Territory", "Portugal", "Palau", "Paraguay", "Qatar", "Reunion", "Romania", "Russian Federation", "Rwanda", "Saudi Arabia", "Solomon Islands", "Seychelles", "Sudan", "Sweden", "Singapore", "Saint Helena", "Slovenia", "Svalbard and Jan Mayen", "Slovakia", "Sierra Leone", "San Marino", "Senegal", "Somalia", "Suriname", "Sao Tome and Principe", "El Salvador", "Syrian Arab Republic", "Swaziland", "Turks and Caicos Islands", "Chad", "French Southern Territories", "Togo", "Thailand", "Tajikistan", "Tokelau", "Turkmenistan", "Tunisia", "Tonga", "Timor-Leste", "Turkey", "Trinidad and Tobago", "Tuvalu", "Taiwan", "Tanzania, United Republic of", "Ukraine", "Uganda", "United States Minor Outlying Islands", "United States", "Uruguay", "Uzbekistan", "Holy See (Vatican City State)", "Saint Vincent and the Grenadines", "Venezuela", "Virgin Islands, British", "Virgin Islands, U.S.", "Vietnam", "Vanuatu", "Wallis and Futuna", "Samoa", "Yemen", "Mayotte", "Serbia", "South Africa", "Zambia", "Montenegro", "Zimbabwe", "Anonymous Proxy", "Satellite Provider", "Other", "Aland Islands", "Guernsey", "Isle of Man", "Jersey", "Saint Barthelemy", "Saint Martin"};

    public LookupService(InputStream databaseFile, int maxDatabaseFile) throws IOException {
        this.file = new InMemoryRandomAccessFile(databaseFile, maxDatabaseFile);
        this.dboptions = 0;
        this.init();
    }

    private void init() throws IOException {
        int l;
        byte[] delim = new byte[3];
        byte[] buf = new byte[3];
        if (this.file == null) {
            for (int i = 0; i < 233; ++i) {
                hashmapcountryCodetoindex.put(COUNTRY_CODE[i], i);
                hashmapcountryNametoindex.put(COUNTRY_NAME[i], i);
            }
            return;
        }
        this.file.seek(this.file.length() - 3L);
        for (int i = 0; i < 20; ++i) {
            this.file.read(delim);
            if (delim[0] == -1 && delim[1] == -1 && delim[2] == -1) {
                this.databaseType = this.file.readByte();
                if (this.databaseType >= 106) {
                    this.databaseType = (byte)(this.databaseType - 105);
                }
                if (this.databaseType == 7) {
                    this.databaseSegments = new int[1];
                    this.databaseSegments[0] = 16700000;
                    this.recordLength = 3;
                    break;
                }
                if (this.databaseType == 3) {
                    this.databaseSegments = new int[1];
                    this.databaseSegments[0] = 16000000;
                    this.recordLength = 3;
                    break;
                }
                if (this.databaseType != 6 && this.databaseType != 2 && this.databaseType != 5 && this.databaseType != 4 && this.databaseType != 9) break;
                this.databaseSegments = new int[1];
                this.databaseSegments[0] = 0;
                this.recordLength = this.databaseType == 6 || this.databaseType == 2 || this.databaseType == 9 ? 3 : 4;
                this.file.read(buf);
                for (int j = 0; j < 3; ++j) {
                    this.databaseSegments[0] = this.databaseSegments[0] + (LookupService.unsignedByteToInt(buf[j]) << j * 8);
                }
                break;
            }
            this.file.seek(this.file.getFilePointer() - 4L);
        }
        if (this.databaseType == 1 | this.databaseType == 8 | this.databaseType == 10) {
            this.databaseSegments = new int[1];
            this.databaseSegments[0] = 0xFFFF00;
            this.recordLength = 3;
        }
        if ((this.dboptions & 1) == 1) {
            l = (int)this.file.length();
            this.dbbuffer = new byte[l];
            this.file.seek(0L);
            this.file.read(this.dbbuffer, 0, l);
            this.databaseInfo = this.getDatabaseInfo();
            this.file.close();
        }
        if ((this.dboptions & 4) != 0) {
            l = this.databaseSegments[0] * this.recordLength * 2;
            this.index_cache = new byte[l];
            if (this.index_cache != null) {
                this.file.seek(0L);
                this.file.read(this.index_cache, 0, l);
            }
        } else {
            this.index_cache = null;
        }
    }

    public void close() {
        try {
            if (this.file != null) {
                this.file.close();
            }
            this.file = null;
        }
        catch (Exception e) {
            LOG.debug("got Exception : {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public Country getCountry(byte[] ipAddress) {
        return this.getCountry(LookupService.bytesToLong(ipAddress));
    }

    public Country getCountry(long ipAddress) {
        if (this.file == null && (this.dboptions & 1) == 0) {
            throw new IllegalStateException("Database has been closed.");
        }
        int ret = this.seekCountry(ipAddress) - 0xFFFF00;
        if (ret == 0) {
            return UNKNOWN_COUNTRY;
        }
        return new Country(COUNTRY_CODE[ret], COUNTRY_NAME[ret]);
    }

    public int getID(long ipAddress) {
        if (this.file == null && (this.dboptions & 1) == 0) {
            throw new IllegalStateException("Database has been closed.");
        }
        int ret = this.seekCountry(ipAddress) - this.databaseSegments[0];
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseInfo getDatabaseInfo() {
        if (this.databaseInfo != null) {
            return this.databaseInfo;
        }
        try {
            LookupService lookupService = this;
            synchronized (lookupService) {
                int i;
                boolean hasStructureInfo = false;
                byte[] delim = new byte[3];
                this.file.seek(this.file.length() - 3L);
                for (i = 0; i < 20; ++i) {
                    this.file.read(delim);
                    if ((delim[0] & 0xFF) != 255 || (delim[1] & 0xFF) != 255 || (delim[2] & 0xFF) != 255) continue;
                    hasStructureInfo = true;
                    break;
                }
                if (hasStructureInfo) {
                    this.file.seek(this.file.getFilePointer() - 3L);
                } else {
                    this.file.seek(this.file.length() - 3L);
                }
                for (i = 0; i < 100; ++i) {
                    this.file.read(delim);
                    if (delim[0] == 0 && delim[1] == 0 && delim[2] == 0) {
                        byte[] dbInfo = new byte[i];
                        this.file.read(dbInfo);
                        this.databaseInfo = new DatabaseInfo(new String(dbInfo));
                        return this.databaseInfo;
                    }
                    this.file.seek(this.file.getFilePointer() - 4L);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("got Exception", (Throwable)e);
        }
        return new DatabaseInfo("");
    }

    public synchronized Location getLocation(long ipnum) {
        byte[] recordBuf = new byte[60];
        int recordBufOffset = 0;
        Location record = new Location();
        int strLength = 0;
        double latitude = 0.0;
        double longitude = 0.0;
        try {
            int j;
            int seekCountry = this.seekCountry(ipnum);
            if (seekCountry == this.databaseSegments[0]) {
                return null;
            }
            int recordPointer = seekCountry + (2 * this.recordLength - 1) * this.databaseSegments[0];
            if ((this.dboptions & 1) == 1) {
                System.arraycopy(this.dbbuffer, recordPointer, recordBuf, 0, Math.min(this.dbbuffer.length - recordPointer, 60));
            } else {
                this.file.seek(recordPointer);
                this.file.read(recordBuf);
            }
            record.countryCode = COUNTRY_CODE[LookupService.unsignedByteToInt(recordBuf[0])];
            record.countryName = COUNTRY_NAME[LookupService.unsignedByteToInt(recordBuf[0])];
            ++recordBufOffset;
            while (recordBuf[recordBufOffset + strLength] != 0) {
                ++strLength;
            }
            if (strLength > 0) {
                record.region = new String(recordBuf, recordBufOffset, strLength);
            }
            recordBufOffset += strLength + 1;
            strLength = 0;
            while (recordBuf[recordBufOffset + strLength] != 0) {
                ++strLength;
            }
            if (strLength > 0) {
                record.city = new String(recordBuf, recordBufOffset, strLength, "ISO-8859-1");
            }
            recordBufOffset += strLength + 1;
            strLength = 0;
            while (recordBuf[recordBufOffset + strLength] != 0) {
                ++strLength;
            }
            if (strLength > 0) {
                record.postalCode = new String(recordBuf, recordBufOffset, strLength);
            }
            recordBufOffset += strLength + 1;
            for (j = 0; j < 3; ++j) {
                latitude += (double)(LookupService.unsignedByteToInt(recordBuf[recordBufOffset + j]) << j * 8);
            }
            record.latitude = (float)latitude / 10000.0f - 180.0f;
            recordBufOffset += 3;
            for (j = 0; j < 3; ++j) {
                longitude += (double)(LookupService.unsignedByteToInt(recordBuf[recordBufOffset + j]) << j * 8);
            }
            record.longitude = (float)longitude / 10000.0f - 180.0f;
            record.metroCode = 0;
            record.dmaCode = 0;
            record.areaCode = 0;
            if (this.databaseType == 2) {
                int metroareaCombo = 0;
                if (record.countryCode == "US") {
                    recordBufOffset += 3;
                    for (j = 0; j < 3; ++j) {
                        metroareaCombo += LookupService.unsignedByteToInt(recordBuf[recordBufOffset + j]) << j * 8;
                    }
                    record.metroCode = record.dmaCode = metroareaCombo / 1000;
                    record.areaCode = metroareaCombo % 1000;
                }
            }
        }
        catch (IOException e) {
            LOG.error("IO Exception while seting up segments", (Throwable)e);
        }
        return record;
    }

    private synchronized int seekCountry(long ipAddress) {
        byte[] buf = new byte[8];
        int[] x = new int[2];
        int offset = 0;
        for (int depth = 31; depth >= 0; --depth) {
            int i;
            if ((this.dboptions & 1) == 1) {
                for (i = 0; i < 8; ++i) {
                    buf[i] = this.dbbuffer[2 * this.recordLength * offset + i];
                }
            } else if ((this.dboptions & 4) != 0) {
                for (i = 0; i < 8; ++i) {
                    buf[i] = this.index_cache[2 * this.recordLength * offset + i];
                }
            } else {
                try {
                    this.file.seek(2 * this.recordLength * offset);
                    this.file.read(buf);
                }
                catch (IOException e) {
                    LOG.warn("IO Exception", (Throwable)e);
                }
            }
            for (i = 0; i < 2; ++i) {
                x[i] = 0;
                for (int j = 0; j < this.recordLength; ++j) {
                    int y = buf[i * this.recordLength + j];
                    if (y < 0) {
                        y += 256;
                    }
                    int n = i;
                    x[n] = x[n] + (y << j * 8);
                }
            }
            if ((ipAddress & (long)(1 << depth)) > 0L) {
                if (x[1] >= this.databaseSegments[0]) {
                    return x[1];
                }
                offset = x[1];
                continue;
            }
            if (x[0] >= this.databaseSegments[0]) {
                return x[0];
            }
            offset = x[0];
        }
        LOG.error("Error seeking country while seeking {}", (Object)ipAddress);
        return 0;
    }

    private static long bytesToLong(byte[] address) {
        long ipnum = 0L;
        for (int i = 0; i < 4; ++i) {
            long y = address[i];
            if (y < 0L) {
                y += 256L;
            }
            ipnum += y << (3 - i) * 8;
        }
        return ipnum;
    }

    private static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }
}

