/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseInfo {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseInfo.class);
    public static final int COUNTRY_EDITION = 1;
    public static final int REGION_EDITION_REV0 = 7;
    public static final int REGION_EDITION_REV1 = 3;
    public static final int CITY_EDITION_REV0 = 6;
    public static final int CITY_EDITION_REV1 = 2;
    public static final int ORG_EDITION = 5;
    public static final int ISP_EDITION = 4;
    public static final int PROXY_EDITION = 8;
    public static final int ASNUM_EDITION = 9;
    public static final int NETSPEED_EDITION = 10;
    private final String info;

    public DatabaseInfo(String info) {
        this.info = info;
    }

    public int getType() {
        if (this.info == null || this.info.equals("")) {
            return 1;
        }
        return Integer.parseInt(this.info.substring(4, 7)) - 105;
    }

    public boolean isPremium() {
        return this.info.indexOf("FREE") < 0;
    }

    public String toString() {
        return this.info;
    }
}

