/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.injector.Injector;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class CompoundHandler
implements Predicate<HttpRequest>,
CommandHandler {
    private final Injector injector;
    private final Map<Predicate<HttpRequest>, BiFunction<Injector, HttpRequest, CommandHandler>> handlers;

    public CompoundHandler(Injector injector, Map<Predicate<HttpRequest>, BiFunction<Injector, HttpRequest, CommandHandler>> handlers) {
        this.injector = Objects.requireNonNull(injector, "Injector must be set");
        Objects.requireNonNull(handlers, "Handlers to use must be set");
        ArrayDeque deque = new ArrayDeque();
        handlers.keySet().forEach(deque::addFirst);
        ImmutableMap.Builder built = ImmutableMap.builder();
        deque.forEach(key -> built.put(key, handlers.get(key)));
        this.handlers = built.build();
    }

    @Override
    public boolean test(HttpRequest request) {
        return this.handlers.keySet().parallelStream().anyMatch(pred -> pred.test(request));
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        BiFunction generator = this.handlers.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(req)).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new UnsupportedCommandException(String.format("Unknown command: (%s) %s", req.getMethod(), req.getUri())));
        CommandHandler handler = (CommandHandler)generator.apply(this.injector, req);
        handler.execute(req, resp);
    }
}

