/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet.console;

import java.io.InputStream;
import org.openqa.grid.internal.TestSlot;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

class MiniCapability {
    private String browser;
    private String version;
    private DesiredCapabilities capabilities;

    MiniCapability(TestSlot slot) {
        DesiredCapabilities cap = new DesiredCapabilities(slot.getCapabilities());
        this.browser = cap.getBrowserName();
        this.version = cap.getVersion();
        this.capabilities = cap;
    }

    public String getVersion() {
        return this.version;
    }

    public String getIcon() {
        return this.getConsoleIconPath(new DesiredCapabilities((Capabilities)this.capabilities));
    }

    private String getConsoleIconPath(DesiredCapabilities cap) {
        String name = this.consoleIconName(cap);
        String path = "org/openqa/grid/images/";
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(path + name + ".png");
        if (in == null) {
            return null;
        }
        return "/grid/resources/" + path + name + ".png";
    }

    private String consoleIconName(DesiredCapabilities cap) {
        String browserString = cap.getBrowserName();
        if (browserString == null || "".equals(browserString)) {
            return "missingBrowserName";
        }
        String ret = browserString;
        if (browserString.contains("iexplore") || browserString.startsWith("*iehta")) {
            ret = "internet explorer";
        } else if (browserString.contains("firefox") || browserString.startsWith("*chrome")) {
            ret = cap.getVersion() != null && cap.getVersion().toLowerCase().equals("beta") || cap.getBrowserName().toLowerCase().contains("beta") ? "firefoxbeta" : (cap.getVersion() != null && cap.getVersion().toLowerCase().equals("aurora") || cap.getBrowserName().toLowerCase().contains("aurora") ? "aurora" : (cap.getVersion() != null && cap.getVersion().toLowerCase().equals("nightly") || cap.getBrowserName().toLowerCase().contains("nightly") ? "nightly" : "firefox"));
        } else if (browserString.startsWith("*safari")) {
            ret = "safari";
        } else if (browserString.startsWith("*googlechrome")) {
            ret = "chrome";
        } else if (browserString.startsWith("opera")) {
            ret = "opera";
        } else if (browserString.toLowerCase().contains("edge")) {
            ret = "MicrosoftEdge";
        }
        return ret.replace(" ", "_");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.browser == null ? 0 : this.browser.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MiniCapability other = (MiniCapability)obj;
        if (this.browser == null ? other.browser != null : !this.browser.equals(other.browser)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

