/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.SeleniumException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverCommandProcessor;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.ServerHttpChannel;

public class DrivenSeleniumLauncher
implements BrowserLauncher {
    private static final Logger log = Logger.getLogger(DrivenSeleniumLauncher.class.getName());
    private final SessionId webdriverSessionId;
    private int port;
    private String seleniumSessionId;
    private DriverSessions sessions;
    private ServerHttpChannel channel;
    private Thread serverThread;

    public DrivenSeleniumLauncher(Capabilities capabilities, RemoteControlConfiguration rcConfig, String sessionId, String browserStartPath) {
        Object value;
        String raw = null;
        if (null != browserStartPath && !browserStartPath.equals("")) {
            raw = browserStartPath;
        }
        if ((value = capabilities.getCapability("webdriver.remote.sessionid")) != null && raw == null) {
            raw = String.valueOf(value);
        }
        if (null == raw) {
            throw new SeleniumException("No webdriver session id given");
        }
        this.webdriverSessionId = new SessionId(raw);
        this.port = rcConfig.getPortDriversShouldContact();
        this.seleniumSessionId = sessionId;
    }

    public void setDriverSessions(DriverSessions sessions) {
        this.sessions = sessions;
    }

    public void launchRemoteSession(String url) {
        Session session = this.sessions.get(this.webdriverSessionId);
        if (session == null) {
            throw new SeleniumException("Unable to locate webdriver session: " + this.webdriverSessionId);
        }
        WebDriver driver = session.getDriver();
        WebDriverCommandProcessor processor = new WebDriverCommandProcessor(url, driver);
        this.channel = new ServerHttpChannel(this.seleniumSessionId, this.port, (CommandProcessor)processor);
        this.serverThread = new Thread(this.channel);
        this.serverThread.setName("WebDriver-backed Selenium for " + this.seleniumSessionId);
        this.serverThread.start();
    }

    public void launchHTMLSuite(String suiteUrl, String baseUrl) {
        throw new UnsupportedOperationException("launchHTMLSuite");
    }

    public void close() {
        Session session = this.sessions.get(this.webdriverSessionId);
        if (session == null) {
            return;
        }
        WebDriver driver = session.getDriver();
        if (driver != null) {
            try {
                driver.quit();
            }
            catch (WebDriverException e) {
                log.log(Level.WARNING, "Cannot quit session", e);
            }
        }
        session.close();
        this.sessions.deleteSession(this.webdriverSessionId);
        this.channel.kill();
        try {
            this.serverThread.join();
        }
        catch (InterruptedException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    @VisibleForTesting
    protected String getSessionId() {
        return this.webdriverSessionId.toString();
    }
}

