/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.FrameGroupCommandQueueSet;
import org.openqa.selenium.server.InjectionHelper;
import org.openqa.selenium.server.RemoteCommandException;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumDriverResourceHandler;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncherFactory;
import org.openqa.selenium.server.browserlaunchers.InvalidBrowserExecutableException;
import org.openqa.selenium.server.log.LoggingManager;
import org.openqa.selenium.server.log.PerSessionLogHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserSessionFactory {
    private static final long DEFAULT_CLEANUP_INTERVAL = 300000L;
    private static final long DEFAULT_MAX_IDLE_SESSION_TIME = 600000L;
    private static Logger log = Logger.getLogger(BrowserSessionFactory.class.getName());
    protected final Set<BrowserSessionInfo> availableSessions = Collections.synchronizedSet(new HashSet());
    protected final Set<BrowserSessionInfo> activeSessions = Collections.synchronizedSet(new HashSet());
    private final BrowserLauncherFactory browserLauncherFactory;
    private final Timer cleanupTimer;
    private final long maxIdleSessionTime;
    private final boolean doCleanup;

    public BrowserSessionFactory(BrowserLauncherFactory blf) {
        this(blf, 300000L, 600000L, true);
    }

    protected BrowserSessionFactory(BrowserLauncherFactory blf, long cleanupInterval, long maxIdleSessionTime, boolean doCleanup) {
        this.browserLauncherFactory = blf;
        this.maxIdleSessionTime = maxIdleSessionTime;
        this.doCleanup = doCleanup;
        this.cleanupTimer = new Timer(true);
        if (doCleanup) {
            this.cleanupTimer.schedule((TimerTask)new CleanupTask(), 0L, cleanupInterval);
        }
    }

    public BrowserSessionInfo getNewBrowserSession(String browserString, String startURL, String extensionJs, Capabilities browserConfigurations, RemoteControlConfiguration configuration) throws RemoteCommandException {
        return this.getNewBrowserSession(browserString, startURL, extensionJs, browserConfigurations, configuration.reuseBrowserSessions(), configuration.isEnsureCleanSession(), configuration);
    }

    protected BrowserSessionInfo getNewBrowserSession(String browserString, String startURL, String extensionJs, Capabilities browserConfigurations, boolean useCached, boolean ensureClean, RemoteControlConfiguration configuration) throws RemoteCommandException {
        BrowserSessionInfo sessionInfo = null;
        browserString = this.validateBrowserString(browserString, configuration);
        if (configuration.getProxyInjectionModeArg()) {
            InjectionHelper.setBrowserSideLogEnabled(configuration.isBrowserSideLogEnabled());
            InjectionHelper.init();
        }
        if (useCached) {
            log.info("grabbing available session...");
            sessionInfo = this.grabAvailableSession(browserString, startURL);
        }
        if (null == sessionInfo) {
            log.info("creating new remote session");
            sessionInfo = this.createNewRemoteSession(browserString, startURL, extensionJs, browserConfigurations, ensureClean, configuration);
        }
        assert (null != sessionInfo);
        return sessionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endAllBrowserSessions(RemoteControlConfiguration configuration) {
        boolean done = false;
        HashSet<BrowserSessionInfo> allSessions = new HashSet<BrowserSessionInfo>();
        while (!done) {
            Set<BrowserSessionInfo> set = this.activeSessions;
            synchronized (set) {
                for (BrowserSessionInfo sessionInfo : this.activeSessions) {
                    allSessions.add(sessionInfo);
                }
            }
            set = this.availableSessions;
            synchronized (set) {
                for (BrowserSessionInfo sessionInfo : this.availableSessions) {
                    allSessions.add(sessionInfo);
                }
            }
            for (BrowserSessionInfo sessionInfo : allSessions) {
                this.endBrowserSession(true, sessionInfo.sessionId, configuration);
            }
            done = 0 == this.activeSessions.size() && 0 == this.availableSessions.size();
            allSessions.clear();
            if (!this.doCleanup) continue;
            this.cleanupTimer.cancel();
        }
    }

    public void endBrowserSession(String sessionId, RemoteControlConfiguration configuration) {
        this.endBrowserSession(false, sessionId, configuration, configuration.isEnsureCleanSession());
    }

    public void endBrowserSession(boolean forceClose, String sessionId, RemoteControlConfiguration configuration) {
        this.endBrowserSession(forceClose, sessionId, configuration, configuration.isEnsureCleanSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void endBrowserSession(boolean forceClose, String sessionId, RemoteControlConfiguration configuration, boolean ensureClean) {
        BrowserSessionInfo sessionInfo = this.lookupInfoBySessionId(sessionId, this.activeSessions);
        if (null != sessionInfo) {
            this.activeSessions.remove(sessionInfo);
            try {
                if (forceClose || !configuration.reuseBrowserSessions()) {
                    this.shutdownBrowserAndClearSessionData(sessionInfo);
                } else {
                    if (null != sessionInfo.session) {
                        sessionInfo.session.reset(sessionInfo.baseUrl);
                    }
                    sessionInfo.lastClosedAt = System.currentTimeMillis();
                    this.availableSessions.add(sessionInfo);
                }
                Object var7_6 = null;
                LoggingManager.perSessionLogHandler().removeSessionLogs(sessionId);
                if (!ensureClean) return;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                LoggingManager.perSessionLogHandler().removeSessionLogs(sessionId);
                if (!ensureClean) throw throwable;
                throw throwable;
            }
        }
        sessionInfo = this.lookupInfoBySessionId(sessionId, this.availableSessions);
        if (null == sessionInfo || !forceClose && configuration.reuseBrowserSessions()) return;
        try {
            this.availableSessions.remove(sessionInfo);
            this.shutdownBrowserAndClearSessionData(sessionInfo);
            Object var9_9 = null;
            LoggingManager.perSessionLogHandler().removeSessionLogs(sessionId);
            if (!ensureClean) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            LoggingManager.perSessionLogHandler().removeSessionLogs(sessionId);
            if (!ensureClean) throw throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void shutdownBrowserAndClearSessionData(BrowserSessionInfo sessionInfo) {
        try {
            sessionInfo.launcher.close();
            Object var3_2 = null;
            if (null == sessionInfo.session) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (null == sessionInfo.session) throw throwable;
            FrameGroupCommandQueueSet.clearQueueSet(sessionInfo.sessionId);
            throw throwable;
        }
        FrameGroupCommandQueueSet.clearQueueSet(sessionInfo.sessionId);
    }

    private String validateBrowserString(String inputString, RemoteControlConfiguration configuration) throws IllegalArgumentException {
        String browserString = inputString;
        if (configuration.getForcedBrowserMode() != null) {
            browserString = configuration.getForcedBrowserMode();
            log.info("overriding browser mode w/ forced browser mode setting: " + browserString);
        }
        if (configuration.getProxyInjectionModeArg() && browserString.equals("*iexplore")) {
            log.warning("running in proxy injection mode, but you used a *iexplore browser string; this is almost surely inappropriate, so I'm changing it to *piiexplore...");
            browserString = "*piiexplore";
        } else if (configuration.getProxyInjectionModeArg() && (browserString.equals("*firefox") || browserString.equals("*firefox2") || browserString.equals("*firefox3"))) {
            log.warning("running in proxy injection mode, but you used a " + browserString + " browser string; this is " + "almost surely inappropriate, so I'm changing it to *pifirefox...");
            browserString = "*pifirefox";
        }
        if (null == browserString) {
            throw new IllegalArgumentException("browser string may not be null");
        }
        return browserString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BrowserSessionInfo grabAvailableSession(String browserString, String baseUrl) {
        BrowserSessionInfo sessionInfo = null;
        Set<BrowserSessionInfo> set = this.availableSessions;
        synchronized (set) {
            sessionInfo = this.lookupInfoByBrowserAndUrl(browserString, baseUrl, this.availableSessions);
            if (null != sessionInfo) {
                this.availableSessions.remove(sessionInfo);
            }
        }
        if (null != sessionInfo) {
            this.activeSessions.add(sessionInfo);
        }
        return sessionInfo;
    }

    protected FrameGroupCommandQueueSet makeQueueSet(String sessionId, int port, RemoteControlConfiguration configuration) {
        return FrameGroupCommandQueueSet.makeQueueSet(sessionId, configuration.getPortDriversShouldContact(), configuration);
    }

    protected FrameGroupCommandQueueSet getQueueSet(String sessionId) {
        return FrameGroupCommandQueueSet.getQueueSet(sessionId);
    }

    protected BrowserSessionInfo createNewRemoteSession(String browserString, String startURL, String extensionJs, Capabilities browserConfiguration, boolean ensureClean, RemoteControlConfiguration configuration) throws RemoteCommandException {
        BrowserLauncher launcher;
        String sessionId = UUID.randomUUID().toString().replace("-", "");
        FrameGroupCommandQueueSet queueSet = this.makeQueueSet(sessionId, configuration.getPortDriversShouldContact(), configuration);
        queueSet.setExtensionJs(extensionJs);
        try {
            launcher = this.browserLauncherFactory.getBrowserLauncher(browserString, sessionId, configuration, browserConfiguration);
        }
        catch (InvalidBrowserExecutableException e) {
            throw new RemoteCommandException(e.getMessage(), "");
        }
        BrowserSessionInfo sessionInfo = new BrowserSessionInfo(sessionId, browserString, startURL, launcher, queueSet);
        SeleniumDriverResourceHandler.setLastSessionId(sessionId);
        log.info("Allocated session " + sessionId + " for " + startURL + ", launching...");
        PerSessionLogHandler perSessionLogHandler = LoggingManager.perSessionLogHandler();
        perSessionLogHandler.attachToCurrentThread(sessionId);
        try {
            launcher.launchRemoteSession(startURL);
            queueSet.waitForLoad(configuration.getTimeoutInSeconds() * 1000L);
            FrameGroupCommandQueueSet queue = this.getQueueSet(sessionId);
            queue.doCommand("setContext", sessionId, "");
            this.activeSessions.add(sessionInfo);
            BrowserSessionInfo browserSessionInfo = sessionInfo;
            Object var15_16 = null;
            perSessionLogHandler.detachFromCurrentThread();
            return browserSessionInfo;
        }
        catch (Exception e) {
            try {
                log.log(Level.SEVERE, "Failed to start new browser session, shutdown browser and clear all session data", e);
                this.shutdownBrowserAndClearSessionData(sessionInfo);
                throw new RemoteCommandException("Error while launching browser", "", e);
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                perSessionLogHandler.detachFromCurrentThread();
                throw throwable;
            }
        }
    }

    protected boolean registerExternalSession(BrowserSessionInfo sessionInfo) {
        boolean result = false;
        if (BrowserSessionInfo.isValid(sessionInfo)) {
            this.activeSessions.add(sessionInfo);
            result = true;
        }
        return result;
    }

    protected void deregisterExternalSession(BrowserSessionInfo sessionInfo) {
        this.activeSessions.remove(sessionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BrowserSessionInfo lookupInfoBySessionId(String sessionId, Set<BrowserSessionInfo> set) {
        BrowserSessionInfo result = null;
        Set<BrowserSessionInfo> set2 = set;
        synchronized (set2) {
            for (BrowserSessionInfo info : set) {
                if (!info.sessionId.equals(sessionId)) continue;
                result = info;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BrowserSessionInfo lookupInfoByBrowserAndUrl(String browserString, String baseUrl, Set<BrowserSessionInfo> set) {
        BrowserSessionInfo result = null;
        Set<BrowserSessionInfo> set2 = set;
        synchronized (set2) {
            for (BrowserSessionInfo info : set) {
                if (!info.browserString.equals(browserString) || !info.baseUrl.equals(baseUrl)) continue;
                result = info;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeIdleAvailableSessions() {
        long now = System.currentTimeMillis();
        Set<BrowserSessionInfo> set = this.availableSessions;
        synchronized (set) {
            Iterator<BrowserSessionInfo> iter = this.availableSessions.iterator();
            while (iter.hasNext()) {
                BrowserSessionInfo info = iter.next();
                if (now - info.lastClosedAt <= this.maxIdleSessionTime) continue;
                iter.remove();
                this.shutdownBrowserAndClearSessionData(info);
            }
        }
    }

    protected boolean hasActiveSession(String sessionId) {
        BrowserSessionInfo info = this.lookupInfoBySessionId(sessionId, this.activeSessions);
        return null != info;
    }

    protected boolean hasAvailableSession(String sessionId) {
        BrowserSessionInfo info = this.lookupInfoBySessionId(sessionId, this.availableSessions);
        return null != info;
    }

    protected void addToAvailableSessions(BrowserSessionInfo sessionInfo) {
        this.availableSessions.add(sessionInfo);
    }

    protected class CleanupTask
    extends TimerTask {
        protected CleanupTask() {
        }

        public void run() {
            BrowserSessionFactory.this.removeIdleAvailableSessions();
        }
    }

    public static class BrowserSessionInfo {
        public final String sessionId;
        public final String browserString;
        public final String baseUrl;
        public final BrowserLauncher launcher;
        public final FrameGroupCommandQueueSet session;
        public long lastClosedAt;

        public BrowserSessionInfo(String sessionId, String browserString, String baseUrl, BrowserLauncher launcher, FrameGroupCommandQueueSet session) {
            this.sessionId = sessionId;
            this.browserString = browserString;
            this.baseUrl = baseUrl;
            this.launcher = launcher;
            this.session = session;
            this.lastClosedAt = 0L;
        }

        protected static boolean isValid(BrowserSessionInfo sessionInfo) {
            boolean result = null != sessionInfo.sessionId && null != sessionInfo.browserString && null != sessionInfo.baseUrl && null != sessionInfo.launcher;
            return result;
        }
    }
}

