/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.interactions;

import java.util.Map;
import org.openqa.selenium.HasInputDevices;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MouseMoveToLocation
extends WebDriverHandler
implements JsonParametersAware {
    private static final String XOFFSET = "xoffset";
    private static final String YOFFSET = "yoffset";
    private static final String ELEMENT = "element";
    String elementId;
    boolean elementProvided = false;
    int xOffset = 0;
    int yOffset = 0;
    boolean offsetsProvided = false;

    public MouseMoveToLocation(Session session) {
        super(session);
    }

    @Override
    public ResultType call() throws Exception {
        Mouse mouse = ((HasInputDevices)this.getDriver()).getMouse();
        Coordinates elementLocation = null;
        if (this.elementProvided) {
            WebElement element = this.getKnownElements().get(this.elementId);
            elementLocation = ((Locatable)element).getCoordinates();
        }
        if (this.offsetsProvided) {
            mouse.mouseMove(elementLocation, (long)this.xOffset, (long)this.yOffset);
        } else {
            mouse.mouseMove(elementLocation);
        }
        return ResultType.SUCCESS;
    }

    public String toString() {
        return String.format("[mousemove: %s %b]", this.elementId, this.offsetsProvided);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        if (allParameters.containsKey(ELEMENT) && allParameters.get(ELEMENT) != null) {
            this.elementId = (String)allParameters.get(ELEMENT);
            this.elementProvided = true;
        } else {
            this.elementProvided = false;
        }
        if (allParameters.containsKey(XOFFSET) && allParameters.containsKey(YOFFSET)) {
            this.xOffset = ((Long)allParameters.get(XOFFSET)).intValue();
            this.yOffset = ((Long)allParameters.get(YOFFSET)).intValue();
            this.offsetsProvided = true;
        } else {
            this.offsetsProvided = false;
        }
    }
}

