/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.jetty.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.openqa.jetty.jetty.servlet.Dispatcher;
import org.openqa.jetty.jetty.servlet.ServletHttpRequest;
import org.openqa.jetty.util.LazyList;

public class JSR154Filter
implements Filter {
    private static ThreadLocal __states = new ThreadLocal();
    private ServletContext _servletContext;
    private Object _requestListeners;
    private Object _requestAttributeListeners;
    private boolean _unwrappedDispatchSupported;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._servletContext = filterConfig.getServletContext();
        this._unwrappedDispatchSupported = Boolean.valueOf(filterConfig.getInitParameter("unwrappedDispatch"));
    }

    protected void setRequestAttributeListeners(Object list) {
        this._requestAttributeListeners = list;
    }

    protected void setRequestListeners(Object list) {
        this._requestListeners = list;
    }

    public boolean isUnwrappedDispatchSupported() {
        return this._unwrappedDispatchSupported;
    }

    public void setUnwrappedDispatchSupported(boolean supportUnwrappedDispatch) {
        this._unwrappedDispatchSupported = supportUnwrappedDispatch;
    }

    public void setDispatch(Dispatcher.DispatcherRequest request, Dispatcher.DispatcherResponse response) {
        ThreadState state = JSR154Filter.state();
        state.dispatchRequest = request;
        state.dispatchResponse = response;
    }

    public Dispatcher.DispatcherRequest getDispatchRequest() {
        ThreadState state = JSR154Filter.state();
        return state.dispatchRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean dispatch;
        ThreadState state;
        boolean root_filter;
        Response responseWrapper;
        Request requestWrapper;
        block15: {
            boolean first_in_context;
            HttpServletRequest srequest = (HttpServletRequest)request;
            HttpServletResponse sresponse = (HttpServletResponse)response;
            requestWrapper = null;
            responseWrapper = null;
            root_filter = false;
            state = JSR154Filter.state();
            if (this._unwrappedDispatchSupported || LazyList.size(this._requestAttributeListeners) > 0) {
                if (srequest instanceof ServletHttpRequest) {
                    state.rootRequest = requestWrapper = new Request(srequest);
                    request = requestWrapper;
                    state.rootResponse = responseWrapper = new Response(sresponse);
                    response = responseWrapper;
                    root_filter = true;
                } else {
                    requestWrapper = state.rootRequest;
                    responseWrapper = state.rootResponse;
                }
            }
            boolean bl = first_in_context = root_filter || requestWrapper != null && requestWrapper.getRequest() != null && requestWrapper.getRequest() instanceof Dispatcher.DispatcherRequest && ((Dispatcher.DispatcherRequest)requestWrapper.getRequest()).crossContext();
            if (first_in_context) {
                this.requestInitialized((ServletRequest)request);
                if (requestWrapper != null && LazyList.size(this._requestAttributeListeners) > 0) {
                    requestWrapper.addContextFilter(this);
                }
            }
            dispatch = false;
            if (this._unwrappedDispatchSupported && state.dispatchRequest != null) {
                dispatch = true;
                requestWrapper.pushWrapper(state.dispatchRequest);
                responseWrapper.pushWrapper(state.dispatchResponse);
                state.dispatchRequest = null;
                state.dispatchResponse = null;
            }
            try {
                chain.doFilter(request, response);
                Object var13_12 = null;
                if (!first_in_context) break block15;
                this.requestDestroyed((ServletRequest)request);
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (first_in_context) {
                    this.requestDestroyed((ServletRequest)request);
                    if (requestWrapper != null && LazyList.size(this._requestAttributeListeners) > 0) {
                        requestWrapper.delContextFilter(this);
                    }
                }
                if (root_filter) {
                    state.clear();
                }
                if (dispatch) {
                    requestWrapper.popWrapper();
                    responseWrapper.popWrapper();
                }
                throw throwable;
            }
            if (requestWrapper != null && LazyList.size(this._requestAttributeListeners) > 0) {
                requestWrapper.delContextFilter(this);
            }
        }
        if (root_filter) {
            state.clear();
        }
        if (dispatch) {
            requestWrapper.popWrapper();
            responseWrapper.popWrapper();
        }
    }

    public void destroy() {
    }

    private void requestInitialized(ServletRequest request) {
        ServletRequestEvent event = new ServletRequestEvent(this._servletContext, request);
        for (int i = 0; i < LazyList.size(this._requestListeners); ++i) {
            ((ServletRequestListener)LazyList.get(this._requestListeners, i)).requestInitialized(event);
        }
    }

    private void requestDestroyed(ServletRequest request) {
        ServletRequestEvent event = new ServletRequestEvent(this._servletContext, request);
        int i = LazyList.size(this._requestListeners);
        while (i-- > 0) {
            ((ServletRequestListener)LazyList.get(this._requestListeners, i)).requestDestroyed(event);
        }
    }

    private void attributeNotify(ServletRequest request, String name, Object oldValue, Object newValue) {
        ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this._servletContext, request, name, oldValue == null ? newValue : oldValue);
        for (int i = 0; i < LazyList.size(this._requestAttributeListeners); ++i) {
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)LazyList.get(this._requestAttributeListeners, i);
            if (oldValue == null) {
                listener.attributeAdded(event);
                continue;
            }
            if (newValue == null) {
                listener.attributeRemoved(event);
                continue;
            }
            listener.attributeReplaced(event);
        }
    }

    private static ThreadState state() {
        ThreadState state = (ThreadState)__states.get();
        if (state == null) {
            state = new ThreadState();
            __states.set(state);
        }
        return state;
    }

    private static class Response
    extends HttpServletResponseWrapper {
        Response(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
        }

        public void pushWrapper(HttpServletResponseWrapper wrapper) {
            wrapper.setResponse(this.getResponse());
            this.setResponse((ServletResponse)wrapper);
        }

        public void popWrapper() {
            HttpServletResponseWrapper wrapper = (HttpServletResponseWrapper)this.getResponse();
            HttpServletResponse response = (HttpServletResponse)wrapper.getResponse();
            this.setResponse((ServletResponse)response);
        }
    }

    private static class Request
    extends HttpServletRequestWrapper {
        Object contextFilters;

        Request(HttpServletRequest httpServletRequest) {
            super(httpServletRequest);
        }

        public void delContextFilter(JSR154Filter filter) {
            this.contextFilters = LazyList.remove(this.contextFilters, filter);
        }

        public void addContextFilter(JSR154Filter filter) {
            this.contextFilters = LazyList.add(this.contextFilters, filter);
        }

        public void setAttribute(String name, Object value) {
            Object old = this.getAttribute(name);
            super.setAttribute(name, value);
            int i = LazyList.size(this.contextFilters);
            while (i-- > 0) {
                ((JSR154Filter)LazyList.get(this.contextFilters, i)).attributeNotify((ServletRequest)this, name, old, value);
            }
        }

        public void removeAttribute(String name) {
            Object old = this.getAttribute(name);
            super.removeAttribute(name);
            int i = LazyList.size(this.contextFilters);
            while (i-- > 0) {
                ((JSR154Filter)LazyList.get(this.contextFilters, i)).attributeNotify((ServletRequest)this, name, old, null);
            }
        }

        public void pushWrapper(HttpServletRequestWrapper wrapper) {
            wrapper.setRequest(this.getRequest());
            this.setRequest((ServletRequest)wrapper);
        }

        public void popWrapper() {
            HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)this.getRequest();
            HttpServletRequest request = (HttpServletRequest)wrapper.getRequest();
            this.setRequest((ServletRequest)request);
        }
    }

    private static class ThreadState {
        Request rootRequest;
        Response rootResponse;
        Dispatcher.DispatcherRequest dispatchRequest;
        Dispatcher.DispatcherResponse dispatchResponse;

        private ThreadState() {
        }

        void clear() {
            this.rootRequest = null;
            this.rootResponse = null;
            this.dispatchRequest = null;
            this.dispatchResponse = null;
        }
    }
}

