/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.SessionId;

public class Response {
    private volatile Object value;
    private volatile String sessionId;
    private volatile Integer status;
    private volatile String state;

    public Response() {
    }

    public Response(SessionId sessionId) {
        this.sessionId = String.valueOf(sessionId);
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        return String.format("(Response: SessionID: %s, Status: %s, Value: %s)", this.getSessionId(), this.getStatus(), this.getValue());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Response)) {
            return false;
        }
        Response that = (Response)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.status, that.status) && Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.sessionId, this.status, this.state);
    }

    private static Response fromJson(Map<String, Object> json) {
        String state;
        ErrorCodes errorCodes = new ErrorCodes();
        Response response = new Response();
        if (json.get("error") instanceof String) {
            state = (String)json.get("error");
            response.setState(state);
            response.setStatus(errorCodes.toStatus(state, Optional.empty()));
            response.setValue(json.get("message"));
        }
        if (json.get("state") instanceof String) {
            state = (String)json.get("state");
            response.setState(state);
            response.setStatus(errorCodes.toStatus(state, Optional.empty()));
        }
        if (json.get("status") != null) {
            Object status = json.get("status");
            if (status instanceof String) {
                String state2 = (String)status;
                response.setState(state2);
                response.setStatus(errorCodes.toStatus(state2, Optional.empty()));
            } else {
                int intStatus = ((Number)status).intValue();
                response.setState(errorCodes.toState(intStatus));
                response.setStatus(intStatus);
            }
        }
        if (json.get("sessionId") instanceof String) {
            response.setSessionId((String)json.get("sessionId"));
        }
        response.setValue(json.getOrDefault("value", json));
        return response;
    }
}

