/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.HandshakeResponse;
import org.openqa.selenium.remote.InitialHandshakeResponse;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;

class Gecko013ProtocolResponse
implements HandshakeResponse {
    private final Function<InitialHandshakeResponse, Optional<ProtocolHandshake.Result>> error = tuple -> {
        Object rawMessage = tuple.getData().get("message");
        Object rawError = tuple.getData().get("error");
        if (!(rawError instanceof String) || !(rawMessage instanceof String)) {
            return Optional.empty();
        }
        Response response = new Response();
        response.setState((String)rawError);
        response.setStatus(new ErrorCodes().toStatus((String)rawError, Optional.of(tuple.getStatusCode())));
        response.setValue(rawMessage);
        new ErrorHandler().throwIfResponseFailed(response, tuple.getRequestDuration().toMillis());
        return Optional.empty();
    };
    private final Function<InitialHandshakeResponse, Optional<ProtocolHandshake.Result>> success = tuple -> {
        Object newValue;
        Map map;
        if (tuple.getData().containsKey("status")) {
            return Optional.empty();
        }
        Object rawSessionId = tuple.getData().get("sessionId");
        Object rawCapabilities = tuple.getData().get("value");
        if (rawCapabilities instanceof Map && (map = (Map)rawCapabilities).containsKey("sessionId") && map.containsKey("value")) {
            rawSessionId = map.get("sessionId");
            rawCapabilities = map.get("value");
        }
        if (!(rawSessionId instanceof String) || !(rawCapabilities instanceof Map)) {
            return Optional.empty();
        }
        if (((Map)rawCapabilities).containsKey("value") && (newValue = ((Map)rawCapabilities).get("value")) instanceof Map) {
            rawCapabilities = newValue;
        }
        for (Object key : ((Map)rawCapabilities).keySet()) {
            if (key instanceof String) continue;
            return Optional.empty();
        }
        Map caps = (Map)rawCapabilities;
        String sessionId = (String)rawSessionId;
        return Optional.of(new ProtocolHandshake.Result(Dialect.W3C, sessionId, caps));
    };

    Gecko013ProtocolResponse() {
    }

    @Override
    public Function<InitialHandshakeResponse, Optional<ProtocolHandshake.Result>> getResponseFunction() {
        return resp -> {
            Optional<ProtocolHandshake.Result> result = this.error.apply((InitialHandshakeResponse)resp);
            if (!result.isPresent()) {
                result = this.success.apply((InitialHandshakeResponse)resp);
            }
            return result;
        };
    }
}

