/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import com.google.common.primitives.Primitives;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonType;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;

class NumberCoercer<T extends Number>
extends TypeCoercer<T> {
    private final Class<T> stereotype;
    private final Function<String, T> mapper;

    NumberCoercer(Class<T> stereotype, Function<String, T> mapper) {
        this.stereotype = Objects.requireNonNull(stereotype);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public boolean test(Class<?> type) {
        return this.stereotype.isAssignableFrom(Primitives.wrap(type));
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, T> apply(Type ignored) {
        return (jsonInput, setting) -> {
            JsonType type = jsonInput.peek();
            if (type != JsonType.NUMBER) {
                throw new JsonException("Cannot coerce something that is not a number to a number: " + (Object)((Object)type));
            }
            String number = jsonInput.nextString();
            return (Number)this.mapper.apply(number);
        };
    }
}

