/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;

public class FindElement
extends WebDriverHandler<Map<String, String>> {
    private static Logger log = Logger.getLogger(FindElement.class.getName());
    private volatile By by;

    public FindElement(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        super.setJsonParameters(allParameters);
        this.by = this.newBySelector().pickFromJsonParameters(allParameters);
    }

    @Override
    public Map<String, String> call() throws Exception {
        try {
            WebElement element = this.getDriver().findElement(this.by);
            String elementId = this.getKnownElements().add(element);
            return ImmutableMap.of((Object)"ELEMENT", (Object)elementId);
        }
        catch (RuntimeException e) {
            if (!(e instanceof NoSuchElementException)) {
                log.log(Level.SEVERE, "Unexpected exception during findElement", e);
            }
            throw e;
        }
    }

    public String toString() {
        return String.format("[find element: %s]", this.by);
    }
}

