/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven.commands;

import com.thoughtworks.selenium.webdriven.ElementFinder;
import com.thoughtworks.selenium.webdriven.JavascriptLibrary;
import com.thoughtworks.selenium.webdriven.SeleneseCommand;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class FireNamedEvent
extends SeleneseCommand<Void> {
    private final ElementFinder elementFinder;
    private final JavascriptLibrary js;
    private final String name;
    private final String fire;

    public FireNamedEvent(ElementFinder elementFinder, JavascriptLibrary js, String name) {
        this.elementFinder = elementFinder;
        this.js = js;
        this.name = name;
        this.fire = "return (" + js.getSeleniumScript("fireEvent.js") + ").apply(null, arguments);";
    }

    @Override
    protected Void handleSeleneseCommand(WebDriver driver, String locator, String ignored) {
        WebElement element = this.elementFinder.findElement(driver, locator);
        this.js.executeScript(driver, this.fire, element, this.name);
        return null;
    }
}

