/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.Type;
import java.util.function.BiFunction;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;

public class StringCoercer
extends TypeCoercer<String> {
    @Override
    public boolean test(Class<?> type) {
        return CharSequence.class.isAssignableFrom(type);
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, String> apply(Type type) {
        return (jsonInput, setting) -> {
            switch (jsonInput.peek()) {
                case BOOLEAN: {
                    return String.valueOf(jsonInput.nextBoolean());
                }
                case NAME: {
                    return jsonInput.nextName();
                }
                case NUMBER: {
                    return String.valueOf(jsonInput.nextNumber());
                }
                case STRING: {
                    return jsonInput.nextString();
                }
            }
            throw new JsonException("Expected value to be a string type: " + String.valueOf((Object)jsonInput.peek()));
        };
    }
}

