/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.security.AddSecretFilter;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.AddWebDriverSpecHeaders;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpCommandCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpResponseCodec;
import org.openqa.selenium.remote.http.AddSeleniumUserAgent;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.UrlTemplate;
import org.openqa.selenium.remote.locators.CustomLocator;

class CustomLocatorHandler
implements Routable {
    private static final Logger LOG = Logger.getLogger(CustomLocatorHandler.class.getName());
    private static final Json JSON = new Json();
    private static final UrlTemplate FIND_ELEMENT = new UrlTemplate("/session/{sessionId}/element");
    private static final UrlTemplate FIND_ELEMENTS = new UrlTemplate("/session/{sessionId}/elements");
    private static final UrlTemplate FIND_CHILD_ELEMENT = new UrlTemplate("/session/{sessionId}/element/{elementId}/element");
    private static final UrlTemplate FIND_CHILD_ELEMENTS = new UrlTemplate("/session/{sessionId}/element/{elementId}/elements");
    private static final Set<String> W3C_STRATEGIES = ImmutableSet.of((Object)"css selector", (Object)"link text", (Object)"partial link text", (Object)"tag name", (Object)"xpath");
    private final HttpHandler toNode;
    private final Map<String, Function<Object, By>> extraLocators;

    @VisibleForTesting
    CustomLocatorHandler(Node node, Secret registrationSecret, Set<CustomLocator> extraLocators) {
        Require.nonNull((String)"Node", (Object)node);
        Require.nonNull((String)"Registration secret", (Object)registrationSecret);
        Require.nonNull((String)"Extra locators", extraLocators);
        HttpHandler nodeHandler = node::executeWebDriverCommand;
        this.toNode = nodeHandler.with((Filter)new AddSeleniumUserAgent()).with((Filter)new AddWebDriverSpecHeaders()).with((Filter)new AddSecretFilter(registrationSecret));
        this.extraLocators = extraLocators.stream().collect(Collectors.toMap(CustomLocator::getLocatorName, locator -> arg_0 -> ((CustomLocator)locator).createBy(arg_0)));
    }

    public boolean matches(HttpRequest req) {
        if (req.getMethod() != HttpMethod.POST) {
            return false;
        }
        return FIND_ELEMENT.match(req.getUri()) != null || FIND_ELEMENTS.match(req.getUri()) != null || FIND_CHILD_ELEMENT.match(req.getUri()) != null || FIND_CHILD_ELEMENTS.match(req.getUri()) != null;
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        RemoteWebElement element;
        String originalContents = Contents.string((HttpMessage)req);
        Map contents = (Map)JSON.toType(originalContents, Json.MAP_TYPE);
        Object using = contents.get("using");
        if (!(using instanceof String)) {
            return (HttpResponse)new HttpResponse().setStatus(400).setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"error", (Object)"invalid argument", (Object)"message", (Object)"Unable to determine element locating strategy", (Object)"stacktrace", (Object)""))));
        }
        if (W3C_STRATEGIES.contains(using)) {
            return this.toNode.execute(req);
        }
        Object value = contents.get("value");
        if (value == null) {
            return (HttpResponse)new HttpResponse().setStatus(400).setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"error", (Object)"invalid argument", (Object)"message", (Object)"Unable to determine element locator arguments", (Object)"stacktrace", (Object)""))));
        }
        Function<Object, By> customLocator = this.extraLocators.get(using);
        if (customLocator == null) {
            LOG.warning(() -> String.format("No custom locator found for '%s', the remote end will determine if the locator is valid.", using));
            return this.toNode.execute(req);
        }
        String usingLocator = String.valueOf(using);
        if ("id".equalsIgnoreCase(usingLocator) || "name".equalsIgnoreCase(usingLocator)) {
            LOG.warning(() -> String.format("Custom conversion to a CSS locator from '%s' will be removed soon. Please switch to a valid W3C WebDriver locator strategy https://www.w3.org/TR/webdriver1/#locator-strategies", using));
        }
        NodeWrappingExecutor executor = new NodeWrappingExecutor(this.toNode);
        CustomWebDriver driver = new CustomWebDriver(executor, (String)HttpSessionId.getSessionId((String)req.getUri()).orElseThrow(() -> new IllegalArgumentException("Cannot locate session ID from " + req.getUri())));
        CustomWebDriver context = null;
        boolean findMultiple = false;
        UrlTemplate.Match match = FIND_ELEMENT.match(req.getUri());
        if (match != null) {
            element = new RemoteWebElement();
            element.setParent((RemoteWebDriver)driver);
            element.setId((String)match.getParameters().get("elementId"));
            context = driver;
        }
        if ((match = FIND_ELEMENTS.match(req.getUri())) != null) {
            element = new RemoteWebElement();
            element.setParent((RemoteWebDriver)driver);
            element.setId((String)match.getParameters().get("elementId"));
            context = driver;
            findMultiple = true;
        }
        if ((match = FIND_CHILD_ELEMENT.match(req.getUri())) != null) {
            element = new RemoteWebElement();
            element.setParent((RemoteWebDriver)driver);
            element.setId((String)match.getParameters().get("elementId"));
            context = element;
        }
        if ((match = FIND_CHILD_ELEMENTS.match(req.getUri())) != null) {
            element = new RemoteWebElement();
            element.setParent((RemoteWebDriver)driver);
            element.setId((String)match.getParameters().get("elementId"));
            context = element;
            findMultiple = true;
        }
        if (context == null) {
            throw new IllegalStateException("Unable to determine locator context: " + String.valueOf(req));
        }
        By by = customLocator.apply(value);
        List toReturn = findMultiple ? context.findElements(by) : context.findElement(by);
        return (HttpResponse)new HttpResponse().setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)toReturn)));
    }

    private static class NodeWrappingExecutor
    implements CommandExecutor {
        private final HttpHandler toNode;
        private final CommandCodec<HttpRequest> commandCodec;
        private final ResponseCodec<HttpResponse> responseCodec;

        public NodeWrappingExecutor(HttpHandler toNode) {
            this.toNode = (HttpHandler)Require.nonNull((String)"Node", (Object)toNode);
            this.commandCodec = new W3CHttpCommandCodec();
            this.responseCodec = new W3CHttpResponseCodec();
        }

        public Response execute(Command command) throws IOException {
            if ("newSession".equals(command.getName())) {
                Response response = new Response();
                response.setState("session not created");
                return response;
            }
            if (command.getSessionId() == null) {
                Response response = new Response();
                response.setState("invalid session id");
                return response;
            }
            HttpRequest request = (HttpRequest)this.commandCodec.encode(command);
            HttpResponse response = this.toNode.execute(request);
            Response decoded = this.responseCodec.decode((Object)response);
            decoded.setSessionId(command.getSessionId().toString());
            return decoded;
        }
    }

    private static class CustomWebDriver
    extends RemoteWebDriver {
        public CustomWebDriver(CommandExecutor executor, String sessionId) {
            super(executor, (Capabilities)new ImmutableCapabilities());
            this.setSessionId(sessionId);
        }

        protected void startSession(Capabilities capabilities) {
        }

        public void quit() {
        }
    }
}

