/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v97.runtime.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v97.runtime.model.UniqueDebuggerId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class StackTraceId {
    private final String id;
    private final Optional<UniqueDebuggerId> debuggerId;

    public StackTraceId(String id, Optional<UniqueDebuggerId> debuggerId) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.debuggerId = debuggerId;
    }

    public String getId() {
        return this.id;
    }

    public Optional<UniqueDebuggerId> getDebuggerId() {
        return this.debuggerId;
    }

    private static StackTraceId fromJson(JsonInput input) {
        String id = null;
        Optional<UniqueDebuggerId> debuggerId = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = input.nextString();
                    continue block8;
                }
                case "debuggerId": {
                    debuggerId = Optional.ofNullable((UniqueDebuggerId)input.read(UniqueDebuggerId.class));
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new StackTraceId(id, debuggerId);
    }
}

