/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v95.indexeddb.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v95.indexeddb.model.ObjectStore;
import org.openqa.selenium.json.JsonInput;

public class DatabaseWithObjectStores {
    private final String name;
    private final Number version;
    private final List<ObjectStore> objectStores;

    public DatabaseWithObjectStores(String name, Number version, List<ObjectStore> objectStores) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.version = Objects.requireNonNull(version, "version is required");
        this.objectStores = Objects.requireNonNull(objectStores, "objectStores is required");
    }

    public String getName() {
        return this.name;
    }

    public Number getVersion() {
        return this.version;
    }

    public List<ObjectStore> getObjectStores() {
        return this.objectStores;
    }

    private static DatabaseWithObjectStores fromJson(JsonInput input) {
        String name = null;
        Number version = 0;
        List objectStores = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block10;
                }
                case "version": {
                    version = input.nextNumber();
                    continue block10;
                }
                case "objectStores": {
                    objectStores = (List)input.read(new TypeToken<List<ObjectStore>>(){}.getType());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DatabaseWithObjectStores(name, version, objectStores);
    }
}

