/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v142.media.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v142.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v142.media.model.PlayerId;
import org.openqa.selenium.json.JsonInput;

public class Player {
    private final PlayerId playerId;
    private final Optional<BackendNodeId> domNodeId;

    public Player(PlayerId playerId, Optional<BackendNodeId> domNodeId) {
        this.playerId = Objects.requireNonNull(playerId, "playerId is required");
        this.domNodeId = domNodeId;
    }

    public PlayerId getPlayerId() {
        return this.playerId;
    }

    public Optional<BackendNodeId> getDomNodeId() {
        return this.domNodeId;
    }

    private static Player fromJson(JsonInput input) {
        PlayerId playerId = null;
        Optional<BackendNodeId> domNodeId = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "playerId": {
                    playerId = (PlayerId)input.read(PlayerId.class);
                    continue block8;
                }
                case "domNodeId": {
                    domNodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Player(playerId, domNodeId);
    }
}

