package org.openqa.selenium.devtools.v142.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class StorageBucket {

    private final org.openqa.selenium.devtools.v142.storage.model.SerializedStorageKey storageKey;

    private final java.util.Optional<java.lang.String> name;

    public StorageBucket(org.openqa.selenium.devtools.v142.storage.model.SerializedStorageKey storageKey, java.util.Optional<java.lang.String> name) {
        this.storageKey = java.util.Objects.requireNonNull(storageKey, "storageKey is required");
        this.name = name;
    }

    public org.openqa.selenium.devtools.v142.storage.model.SerializedStorageKey getStorageKey() {
        return storageKey;
    }

    /**
     * If not specified, it is the default bucket of the storageKey.
     */
    public java.util.Optional<java.lang.String> getName() {
        return name;
    }

    private static StorageBucket fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v142.storage.model.SerializedStorageKey storageKey = null;
        java.util.Optional<java.lang.String> name = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "storageKey":
                    storageKey = input.read(org.openqa.selenium.devtools.v142.storage.model.SerializedStorageKey.class);
                    break;
                case "name":
                    name = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new StorageBucket(storageKey, name);
    }
}
